/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.drops.droppables;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.drops.Drop;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.IIntangibleDrop;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandDrop
extends Drop
implements IIntangibleDrop {
    protected PlaceholderString command;
    protected boolean asCaster = false;
    protected boolean asOP = false;

    public CommandDrop(String line, MythicLineConfig config) {
        super(line, config);
        this.command = PlaceholderString.of(config.getString(new String[]{"command", "cmd", "c"}));
        this.asCaster = config.getBoolean(new String[]{"ascaster", "caster", "ac", "sudo", "asmob"}, false);
        this.asOP = config.getBoolean(new String[]{"asop", "op"}, false);
    }

    public CommandDrop(String line, MythicLineConfig config, double amount) {
        super(line, config, amount);
        this.command = PlaceholderString.of(config.getString(new String[]{"command", "cmd", "c"}));
        this.asCaster = config.getBoolean(new String[]{"ascaster", "caster", "ac", "sudo", "asmob"}, false);
        this.asOP = config.getBoolean(new String[]{"asop", "op"}, false);
    }

    @Override
    public void giveDrop(AbstractPlayer target, DropMetadata data) {
        String parsedCommand = this.command.get(data, target);
        parsedCommand = parsedCommand.replace("<drop.amount>", String.valueOf(data.getAmount()));
        if (this.asCaster) {
            if (data.getCaster().getEntity().isPlayer()) {
                Player player = (Player)BukkitAdapter.adapt(data.getCaster().getEntity());
                if (this.asOP) {
                    boolean op = player.isOp();
                    player.setOp(true);
                    Bukkit.getServer().dispatchCommand((CommandSender)player, parsedCommand);
                    player.setOp(op);
                } else {
                    Bukkit.getServer().dispatchCommand((CommandSender)player, parsedCommand);
                }
            } else {
                MythicMobs.inst().server().dispatchCommand("minecraft:execute " + data.getCaster().getEntity().getUniqueId() + " ~ ~ ~ " + parsedCommand);
            }
        } else {
            MythicMobs.inst().server().dispatchCommand(parsedCommand);
        }
    }
}

