/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.drops.droppables;

import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicDropLoadEvent;
import io.lumine.xikage.mythicmobs.drops.Drop;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class CustomDrop
extends Drop {
    protected final String dropName;
    protected Drop drop = null;
    protected boolean loaded = false;

    public CustomDrop(String drop, String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.dropName = drop;
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Loading CustomDrop with name " + drop, new Object[0]);
        Schedulers.sync().runLater(() -> {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Attempting to Register CustomDrop: " + drop, new Object[0]);
            MythicDropLoadEvent event = new MythicDropLoadEvent(this, this.dropName, mlc);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.getDrop().isPresent()) {
                this.drop = event.getDrop().get();
                this.loaded = true;
            } else {
                MythicLogger.errorDropConfig(this, mlc, "Drop type not found.");
            }
        }, 1L);
    }

    public String getConfigLine() {
        return this.getLine();
    }

    public Optional<Drop> getDrop() {
        return Optional.ofNullable(this.drop);
    }

    public String getDropArgument() {
        return this.dropVar;
    }

    @Override
    public void rollAmount(DropMetadata data) {
        super.rollAmount(data);
        double amount = this.getAmount();
        if (this.drop != null) {
            this.drop.setAmount(amount);
        }
    }
}

