/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.holograms;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.PluginComponent;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.compatibility.CompatibilityManager;
import io.lumine.xikage.mythicmobs.holograms.HologramProvider;
import io.lumine.xikage.mythicmobs.holograms.IHologram;
import io.lumine.xikage.mythicmobs.holograms.types.CastBar;
import io.lumine.xikage.mythicmobs.holograms.types.HealthBar;
import io.lumine.xikage.mythicmobs.holograms.types.Nameplate;
import io.lumine.xikage.mythicmobs.holograms.types.SpeechBubble;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.mechanics.CastMechanic;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.logging.ConsoleColor;

public class HologramManager
extends PluginComponent {
    private final CompatibilityManager compat;
    private HologramProvider provider;

    public HologramManager(MythicMobs core, CompatibilityManager compat) {
        super(core);
        this.compat = compat;
    }

    @Override
    public void load(MythicMobs plugin) {
        Schedulers.sync().runLater(() -> this.initialize(), 1L);
    }

    @Override
    public void unload() {
    }

    private void initialize() {
        if (this.compat.getHolograms().isPresent()) {
            MythicLogger.log("" + (Object)((Object)ConsoleColor.GREEN) + (Object)((Object)ConsoleColor.CHECK_MARK) + "Using Holograms plugin for holograms");
            this.provider = this.compat.getHolograms().get();
        } else if (this.compat.getHolographicDisplays().isPresent()) {
            MythicLogger.log("" + (Object)((Object)ConsoleColor.GREEN) + (Object)((Object)ConsoleColor.CHECK_MARK) + "Using HolographicDisplays plugin for holograms");
            this.provider = this.compat.getHolographicDisplays().get();
        } else {
            this.provider = null;
            return;
        }
    }

    public boolean isActive() {
        return this.provider != null;
    }

    public IHologram createHologram(String name, AbstractLocation location) {
        return this.provider == null ? null : this.provider.createHologram(name, location, " ");
    }

    public IHologram createHologram(String name, AbstractLocation location, String text) {
        return this.provider == null ? null : this.provider.createHologram(name, location, text);
    }

    public Nameplate createNameplate(ActiveMob activeMob) {
        return this.provider == null ? null : new Nameplate(this, activeMob);
    }

    public HealthBar createHealthBar(ActiveMob activeMob) {
        return this.provider == null ? null : new HealthBar(this, activeMob);
    }

    public SpeechBubble createSpeechBubble(SkillCaster skillCaster) {
        return this.provider == null ? null : new SpeechBubble(this, skillCaster);
    }

    public CastBar createCastBar(CastMechanic.CastTracker castTracker, String castingText) {
        return this.provider == null ? null : new CastBar(this, castTracker, castingText);
    }
}

