/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.io;

import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.utils.config.file.FileConfiguration;
import io.lumine.xikage.mythicmobs.utils.config.file.YamlConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;

public class IOLoader<T extends JavaPlugin> {
    private T plugin;
    private File file = null;
    private FileConfiguration fileConfig = null;
    private String defaultFile;

    public IOLoader(T plugin, String newfile) {
        this(plugin, newfile, null);
    }

    public IOLoader(T plugin, String newfile, String folder) {
        this.plugin = plugin;
        this.defaultFile = newfile;
        if (folder != null) {
            folder = folder.replace("/", System.getProperty("file.separator"));
            String path = plugin.getDataFolder() + System.getProperty("file.separator") + folder;
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdir();
            }
            this.file = new File(plugin.getDataFolder() + System.getProperty("file.separator") + folder, newfile);
        } else {
            this.file = new File(plugin.getDataFolder(), newfile);
        }
        this.reloadCustomConfig(!this.file.exists());
    }

    public IOLoader(T plugin, File newfile, String folder) {
        this.plugin = plugin;
        this.file = newfile;
        this.reloadCustomConfig(this.file == null);
    }

    public void reloadCustomConfig(boolean loadDefaults) {
        if (loadDefaults && this.file != null) {
            this.file = new File(this.file.getParent(), this.defaultFile);
            this.fileConfig = YamlConfiguration.loadConfiguration(this.file);
            InputStream defConfigStream = this.plugin.getResource(this.defaultFile);
            if (defConfigStream != null) {
                InputStreamReader reader = new InputStreamReader(defConfigStream);
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration(reader);
                this.fileConfig.setDefaults(defConfig);
            }
            this.getCustomConfig().options().copyDefaults(true);
            MythicLogger.log("File " + this.defaultFile + " not found! Creating a new one...");
            this.saveCustomConfig();
        } else {
            this.fileConfig = YamlConfiguration.loadConfiguration(this.file);
        }
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getCustomConfig() {
        if (this.fileConfig == null) {
            this.reloadCustomConfig(this.file == null);
        }
        return this.fileConfig;
    }

    public void saveCustomConfig() {
        if (this.fileConfig == null || this.file == null) {
            return;
        }
        try {
            this.getCustomConfig().save(this.file);
        }
        catch (IOException ex) {
            if (ConfigManager.debugLevel > 0) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + this.file, ex);
            }
            MythicLogger.error("Severe Error: Could not save config to " + this.file + ". Turn on debugging if this error keeps occuring for details.");
        }
    }
}

