/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.mobs;

import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class MobRegistry
implements Terminable {
    private transient ConcurrentHashMap<UUID, ActiveMob> activeMobs = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, ActiveMob> persistentMobs = new ConcurrentHashMap();

    public void loadSaved() {
        this.activeMobs.putAll(this.persistentMobs);
        this.activeMobs.values().removeIf(mob -> !mob.loadSaved());
    }

    @Override
    public void close() {
        this.activeMobs.values().removeIf(mob -> mob.getType().getDespawns());
        this.activeMobs.values().forEach(mob -> mob.getVariables().unload());
    }

    public boolean isActiveMob(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        if (this.activeMobs.containsKey(uuid)) {
            if (this.activeMobs.get(uuid).getType() != null) {
                return true;
            }
            this.activeMobs.remove(uuid);
        }
        if (this.persistentMobs.containsKey(uuid)) {
            ActiveMob am = this.persistentMobs.get(uuid);
            this.activeMobs.put(uuid, am);
            am.loadSaved();
            return true;
        }
        return false;
    }

    public Optional<ActiveMob> getActiveMob(UUID uuid) {
        if (this.isActiveMob(uuid)) {
            return Optional.ofNullable(this.activeMobs.getOrDefault(uuid, null));
        }
        return Optional.empty();
    }

    public Collection<ActiveMob> values() {
        return this.activeMobs.values();
    }

    public void put(UUID uuid, ActiveMob mob) {
        this.activeMobs.put(uuid, mob);
        if (!mob.getType().getDespawns()) {
            this.persistentMobs.put(uuid, mob);
        }
    }

    public void setInactive(UUID uuid) {
        this.activeMobs.remove(uuid);
    }

    public void removeMob(UUID uuid) {
        this.activeMobs.remove(uuid);
        this.persistentMobs.remove(uuid);
    }

    public ActiveMob get(UUID uniqueId) {
        if (this.isActiveMob(uniqueId)) {
            return this.activeMobs.get(uniqueId);
        }
        return null;
    }
}

