/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.mobs;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractBossBar;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMobSpawnEvent;
import io.lumine.xikage.mythicmobs.compatibility.CompatibilityManager;
import io.lumine.xikage.mythicmobs.compatibility.MPetCompat;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.DropTable;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicEntityType;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.TriggeredSkill;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MythicMob
implements Comparable<MythicMob> {
    private String file;
    private MythicConfig config;
    private String internalName;
    protected String strMobType;
    protected BukkitEntityType mobType;
    protected Optional<MPetCompat.MiniaturePetType> mPetType;
    protected PlaceholderString displayName;
    protected String faction;
    private DropTable dropTable;
    private DropTable equipmentTable;
    protected PlaceholderDouble attrHealth;
    protected PlaceholderDouble attrDamage;
    protected PlaceholderDouble attrArmor;
    protected PlaceholderDouble attrMovementSpeed;
    protected double attrKnockbackResist;
    protected double attrFollowRange;
    protected double attrAttackSpeed;
    protected double lvlModDamage;
    protected double lvlModHealth;
    protected double lvlModArmor;
    protected double lvlModKBR;
    protected double lvlModPower;
    protected double lvlModSpeed;
    protected double lvlModAttackSpeed;
    protected boolean optionDespawn;
    protected boolean optionPersistent;
    protected boolean optionShowHealthInChat;
    protected boolean optionSilent;
    protected boolean optionNoAI;
    protected boolean optionGlowing;
    protected boolean optionInvincible;
    protected boolean optionCollidable;
    protected boolean optionNoGravity;
    protected boolean optionInteractable;
    protected Boolean optionLockPitch;
    protected boolean useBossBar;
    protected int bossBarRange;
    protected int bossBarRangeSq;
    protected PlaceholderString bossBarTitle;
    protected AbstractBossBar.BarColor bossBarColor;
    protected AbstractBossBar.BarStyle bossBarStyle;
    protected boolean bossBarCreateFog;
    protected boolean bossBarDarkenSky;
    protected boolean bossBarPlayMusic;
    protected Optional<String> mount;
    protected Optional<String> rider;
    private Map<String, Double> damageModifiers;
    private Map<String, Double> entityDamageModifiers;
    private List<String> levelmods;
    private List<String> aiGoalSelectors;
    private List<String> aiTargetSelectors;
    private boolean hasCombatSkills;
    private Map<SkillTrigger, Queue<SkillMechanic>> skills;
    private Queue<SkillMechanic> timerSkills;
    private Map<String, SkillMechanic> signalSkills;
    private boolean usingTimers;
    int size;
    private int noDamageTicks;
    private int maxAttackRange;
    private int maxAttackableRange;
    private int maxThreatDistance;
    private boolean alwaysShowName;
    private boolean showNameOnDamage;
    private boolean useThreatTable;
    private boolean useImmunityTable;
    private boolean useCustomNameplate;
    private boolean optionTTFromDamage;
    private boolean optionTTDecayUnreachable;
    private Boolean repeatAllSkills;
    private Boolean preventOtherDrops;
    private Boolean preventRandomEquipment;
    private Boolean preventLeashing;
    private Boolean preventRename;
    private Boolean preventSlimeSplit;
    private Boolean preventEndermanTeleport;
    private Boolean preventItemPickup;
    private Boolean preventSilverfishInfection;
    private Boolean preventSunburn;
    private Boolean preventExploding;
    private Boolean preventMobKillDrops;
    private Boolean preventTransformation;
    private Boolean preventJockeyMounts;
    private Boolean passthroughDamage;
    private Boolean applyInvisibility;
    private Boolean digOutOfGround;
    private Boolean usesHealthBar;
    protected double spawnVelocityX;
    protected double spawnVelocityXMax;
    protected double spawnVelocityY;
    protected double spawnVelocityYMax;
    protected double spawnVelocityZ;
    protected double spawnVelocityZMax;
    protected boolean spawnVelocityXRange;
    protected boolean spawnVelocityYRange;
    protected boolean spawnVelocityZRange;
    protected List<PlaceholderString> killMessages;
    private String disguise;
    private boolean fakePlayer;
    private boolean legacyDisguise;
    private final transient ReentrantLock skillLock;

    private static final MythicMobs getPlugin() {
        return MythicMobs.inst();
    }

    private static final MobManager getMobManager() {
        return MythicMobs.inst().getMobManager();
    }

    public MythicMob(String file, String internalName, MythicConfig mc) {
        block83: {
            List<String> list;
            List<String> list2;
            this.mPetType = Optional.empty();
            this.faction = null;
            this.optionShowHealthInChat = false;
            this.optionSilent = false;
            this.optionNoAI = false;
            this.optionGlowing = false;
            this.optionInvincible = false;
            this.optionCollidable = true;
            this.optionNoGravity = true;
            this.optionInteractable = true;
            this.optionLockPitch = false;
            this.useBossBar = false;
            this.mount = Optional.empty();
            this.rider = Optional.empty();
            this.aiGoalSelectors = new ArrayList<String>();
            this.aiTargetSelectors = new ArrayList<String>();
            this.hasCombatSkills = false;
            this.skills = Maps.newConcurrentMap();
            this.timerSkills = Queues.newConcurrentLinkedQueue();
            this.signalSkills = Maps.newConcurrentMap();
            this.usingTimers = false;
            this.alwaysShowName = true;
            this.showNameOnDamage = true;
            this.optionTTFromDamage = true;
            this.optionTTDecayUnreachable = true;
            this.repeatAllSkills = false;
            this.preventOtherDrops = false;
            this.preventRandomEquipment = false;
            this.preventLeashing = false;
            this.preventRename = true;
            this.preventSlimeSplit = true;
            this.preventEndermanTeleport = true;
            this.preventItemPickup = true;
            this.preventSilverfishInfection = true;
            this.preventSunburn = false;
            this.preventExploding = false;
            this.preventMobKillDrops = false;
            this.preventTransformation = true;
            this.preventJockeyMounts = false;
            this.passthroughDamage = false;
            this.applyInvisibility = false;
            this.digOutOfGround = false;
            this.usesHealthBar = false;
            this.spawnVelocityXMax = 0.0;
            this.spawnVelocityYMax = 0.0;
            this.spawnVelocityZMax = 0.0;
            this.spawnVelocityXRange = false;
            this.spawnVelocityYRange = false;
            this.spawnVelocityZRange = false;
            this.disguise = null;
            this.fakePlayer = false;
            this.legacyDisguise = false;
            this.skillLock = new ReentrantLock();
            this.config = mc;
            this.file = file;
            this.internalName = internalName;
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Loading MythicMob type '{0}'...", this.internalName);
            this.strMobType = mc.getString("Type", this.strMobType);
            this.strMobType = mc.getString("MobType", this.strMobType);
            this.strMobType = mc.getString("Mobtype", this.strMobType);
            if (this.strMobType == null) {
                BukkitEntityType me = BukkitEntityType.getMythicEntity(internalName);
                if (me == null) {
                    MythicLogger.errorMobConfig(this, mc, "Could not load MythicMob " + this.internalName + "! No Type specified.");
                    this.strMobType = "NULL";
                    this.mobType = BukkitEntityType.getMythicEntity("SKELETON");
                    this.displayName = PlaceholderString.of("ERROR: MOB TYPE FOR '" + this.internalName + "' IS NOT OPTIONAL");
                    return;
                }
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "+ EntityType is vanilla override for {0}", this.strMobType);
                this.mobType = me;
            } else {
                MythicMob.getMobManager();
                this.strMobType = MobManager.convertMobTypeAliases(this.strMobType);
                if (this.strMobType.equalsIgnoreCase("MINIATUREPET") || this.strMobType.equalsIgnoreCase("MPET")) {
                    if (MythicMob.getPlugin().getCompatibility().getMiniaturePets().isPresent()) {
                        try {
                            MPetCompat compat;
                            MPetCompat mPetCompat = compat = MythicMob.getPlugin().getCompatibility().getMiniaturePets().get();
                            mPetCompat.getClass();
                            this.mPetType = Optional.of(new MPetCompat.MiniaturePetType(mPetCompat, mc));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        MythicLogger.errorMobConfig(this, mc, "Could not load MiniaturePets type: MiniaturePets is not enabled.");
                        this.mobType = BukkitEntityType.getMythicEntity(MythicEntityType.ZOMBIE);
                    }
                } else {
                    this.mobType = BukkitEntityType.getMythicEntity(this.strMobType);
                }
            }
            if (this.mobType != null) {
                this.mobType.instantiate(mc);
            } else if (!this.mPetType.isPresent()) {
                MythicLogger.error("Could not load MythicMob {0}! Invalid type specified.", this.internalName);
                this.strMobType = "NULL";
                this.mobType = BukkitEntityType.getMythicEntity("SKELETON");
                this.displayName = PlaceholderString.of("ERROR: MOB TYPE FOR '" + this.internalName + "' IS INVALID");
                return;
            }
            String strDisplayName = mc.getString("Display", this.displayName == null ? null : this.displayName.toString());
            strDisplayName = mc.getString("DisplayName", strDisplayName);
            if (strDisplayName != null) {
                this.displayName = PlaceholderString.of(strDisplayName);
            }
            this.attrHealth = mc.getPlaceholderDouble("Health", "-1");
            this.attrDamage = mc.getPlaceholderDouble("Damage", "-1");
            this.attrArmor = mc.getPlaceholderDouble(new String[]{"Armor", "Armour"}, "-1", new String[0]);
            this.optionInvincible = mc.getBoolean("Options.Invincible", false);
            this.optionInvincible = mc.getBoolean("Options.Invulnerable", this.optionInvincible);
            this.faction = mc.getString("Faction", null);
            String mount = mc.getString("Mount", null);
            mount = mc.getString("Riding", mount);
            this.mount = Optional.ofNullable(mount);
            String rider = mc.getString("Rider", null);
            rider = mc.getString("Passenger", rider);
            this.rider = Optional.ofNullable(rider);
            this.optionDespawn = mc.getBoolean("Despawn", MythicMob.getPlugin().getConfiguration().getDespawnMobsByDefault());
            this.optionDespawn = mc.getBoolean("Options.Despawn", this.optionDespawn);
            this.optionPersistent = mc.getBoolean("Persistent", false);
            this.optionPersistent = mc.getBoolean("Options.Persistent", this.optionPersistent);
            this.attrAttackSpeed = mc.getDouble("Options.AttackSpeed", 0.0);
            this.attrMovementSpeed = mc.getPlaceholderDouble("Options.MovementSpeed", "0");
            this.attrKnockbackResist = mc.getDouble("Options.KnockbackResistance", 0.0);
            this.attrFollowRange = mc.getDouble("Options.FollowRange", 0.0);
            this.attrAttackSpeed = mc.getDouble("Options.AttackSpeed", 0.0);
            this.optionGlowing = mc.getBoolean("Options.Glowing", false);
            this.optionCollidable = mc.getBoolean("Options.Collidable", true);
            this.optionNoGravity = mc.getBoolean("Options.NoGravity", false);
            this.optionInteractable = mc.getBoolean("Options.Interactable", this.optionInteractable);
            this.optionSilent = mc.getBoolean("Options.Silent", this.optionSilent);
            this.optionNoAI = mc.getBoolean("Options.NoAI", this.optionNoAI);
            this.noDamageTicks = mc.getInteger("Options.NoDamageTicks", 10) * 2;
            this.optionLockPitch = mc.getBoolean("Options.LockPitch", this.optionLockPitch);
            this.useBossBar = mc.getBoolean("BossBar.Enabled", false);
            this.bossBarTitle = mc.getPlaceholderString("BossBar.Title", this.displayName == null ? "" : this.displayName.toString());
            this.bossBarRange = mc.getInteger("BossBar.Range", 64);
            this.bossBarRangeSq = (int)Math.pow(this.bossBarRange, 2.0);
            String bossBarColor = mc.getString("BossBar.Color", "WHITE");
            String bossBarStyle = mc.getString("BossBar.Style", "SOLID");
            try {
                this.bossBarColor = AbstractBossBar.BarColor.valueOf(bossBarColor);
            }
            catch (Exception ex) {
                this.bossBarColor = AbstractBossBar.BarColor.WHITE;
            }
            try {
                this.bossBarStyle = AbstractBossBar.BarStyle.valueOf(bossBarStyle);
            }
            catch (Exception ex) {
                this.bossBarStyle = AbstractBossBar.BarStyle.SOLID;
            }
            this.bossBarCreateFog = mc.getBoolean("BossBar.CreateFog", false);
            this.bossBarDarkenSky = mc.getBoolean("BossBar.DarkenSky", false);
            this.bossBarPlayMusic = mc.getBoolean("BossBar.PlayMusic", false);
            this.usesHealthBar = mc.getBoolean("HealthBar.Enabled", false);
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Loading mob skills... ", new Object[0]);
            List<String> nSkills = mc.getStringList("Skills");
            int interval = 1;
            for (String string : nSkills) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Loading mechanic line: {0}", string);
                String string2 = MythicLineConfig.unparseBlock(string);
                SkillMechanic skillMechanic = MythicMob.getPlugin().getSkillManager().getSkillMechanic(string2);
                if (skillMechanic != null) {
                    Matcher Rmatcher;
                    Pattern Rpattern;
                    if (string2.contains("~onTimer")) {
                        Rpattern = Pattern.compile("~onTimer:([0-9]+)");
                        Rmatcher = Rpattern.matcher(string2);
                        Rmatcher.find();
                        try {
                            interval = Integer.parseInt(Rmatcher.group(1));
                        }
                        catch (Exception e) {
                            MythicLogger.errorMobConfig(this, mc, "Error parsing Timer skill, invalid interval specified (must be an integer). AbstractSkill=" + string2);
                            continue;
                        }
                        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Mechanic set on timer with interval {0}", interval);
                        skillMechanic.setTimerInterval(interval);
                        this.timerSkills.add(skillMechanic);
                        continue;
                    }
                    if (string2.contains("~onSignal:")) {
                        String signal;
                        Rpattern = Pattern.compile("~onSignal:([a-zA-Z0-9_-]*)");
                        Rmatcher = Rpattern.matcher(string2);
                        Rmatcher.find();
                        try {
                            signal = Rmatcher.group(1);
                        }
                        catch (Exception e) {
                            MythicLogger.errorMobConfig(this, mc, "Error parsing Signal skill, invalid signal specified (contains invalid characters). AbstractSkill=" + string2);
                            continue;
                        }
                        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Mechanic set on Signal with key '{0}'", signal);
                        this.signalSkills.put(signal, skillMechanic);
                        continue;
                    }
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Loading mechanic to base skill tree...", new Object[0]);
                    SkillTrigger trigger = skillMechanic.getTrigger();
                    if (!this.skills.containsKey((Object)trigger)) {
                        this.skills.put(trigger, Queues.newConcurrentLinkedQueue());
                    }
                    this.skills.get((Object)skillMechanic.getTrigger()).add(skillMechanic);
                    continue;
                }
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Mechanic was not found. Skipping.", new Object[0]);
            }
            if (this.timerSkills.size() > 0) {
                this.usingTimers = true;
            }
            if (this.hasSkills(SkillTrigger.COMBAT)) {
                this.hasCombatSkills = true;
            }
            this.optionShowHealthInChat = mc.getBoolean("ShowHealth", false);
            this.useThreatTable = mc.getBoolean("Modules.ThreatTable", false);
            this.useImmunityTable = mc.getBoolean("Modules.ImmunityTable", false);
            this.useCustomNameplate = mc.getBoolean("Nameplate.Enabled", false);
            this.useThreatTable = mc.getBoolean("Options.UseThreatTable", this.useThreatTable);
            this.useImmunityTable = mc.getBoolean("Options.UseImmunityTable", this.useImmunityTable);
            this.useThreatTable = mc.getBoolean("ThreatTable.Enabled", this.useThreatTable);
            this.optionTTFromDamage = mc.getBoolean("ThreatTable.UseDamageTaken", true);
            this.optionTTDecayUnreachable = mc.getBoolean("ThreatTable.DecayUnreachable", true);
            this.useThreatTable = mc.getBoolean("ThreatTables.Enabled", this.useThreatTable);
            this.optionTTFromDamage = mc.getBoolean("ThreatTables.UseDamageTaken", this.optionTTFromDamage);
            this.optionTTDecayUnreachable = mc.getBoolean("ThreatTables.DecayUnreachable", this.optionTTDecayUnreachable);
            this.maxAttackRange = mc.getInteger("Options.MaxAttackRange", 64);
            this.maxAttackableRange = mc.getInteger("Options.MaxCombatDistance", 256);
            this.maxAttackableRange = mc.getInteger("Options.MaxAttackableRange", this.maxAttackableRange);
            this.maxThreatDistance = mc.getInteger("Options.MaxThreatDistance", 40);
            this.alwaysShowName = mc.getBoolean("Options.AlwaysShowName", false);
            this.showNameOnDamage = mc.getBoolean("Options.ShowNameOnDamaged", false);
            this.repeatAllSkills = mc.getBoolean("Options.RepeatAllSkills", false);
            this.preventOtherDrops = mc.getBoolean("Options.PreventOtherDrops", MythicMob.getPlugin().getConfiguration().getPreventOtherDropsByDefault());
            this.preventRandomEquipment = mc.getBoolean("Options.PreventRandomEquipment", false);
            this.preventLeashing = mc.getBoolean("Options.PreventLeashing", true);
            this.preventRename = mc.getBoolean("Options.PreventRenaming", true);
            this.preventSlimeSplit = mc.getBoolean("Options.PreventSplit", true);
            this.preventSlimeSplit = mc.getBoolean("Options.PreventSlimeSplit", this.preventSlimeSplit);
            this.preventSunburn = mc.getBoolean("Options.PreventSunburn", false);
            this.preventEndermanTeleport = mc.getBoolean("Options.PreventTeleport", false);
            this.preventEndermanTeleport = mc.getBoolean("Options.PreventTeleporting", this.preventEndermanTeleport);
            this.preventTransformation = mc.getBoolean("Options.PreventTransformation", true);
            this.preventTransformation = mc.getBoolean("Options.PreventTransforming", this.preventTransformation);
            this.preventTransformation = mc.getBoolean("Options.PreventTransform", this.preventTransformation);
            this.preventJockeyMounts = mc.getBoolean("Options.PreventJockeyMounts", false);
            this.preventItemPickup = mc.getBoolean("Options.PreventItemPickup", true);
            this.preventMobKillDrops = mc.getBoolean("Options.PreventMobKillDrops", false);
            this.passthroughDamage = mc.getBoolean("Options.PassthroughDamage", false);
            this.applyInvisibility = mc.getBoolean("Options.ApplyInvisibility", false);
            List<String> lstAIGoalSelectors = mc.getStringList("AIGoalSelectors");
            if (lstAIGoalSelectors != null) {
                for (String string : lstAIGoalSelectors) {
                    String string3 = MythicLineConfig.unparseBlock(string);
                    this.aiGoalSelectors.add(string3);
                }
            }
            if ((list2 = mc.getStringList("AITargetSelectors")) != null) {
                for (String s4 : list2) {
                    s4 = MythicLineConfig.unparseBlock(s4);
                    this.aiTargetSelectors.add(s4);
                }
            }
            List<String> list3 = mc.getStringList("Drops");
            this.dropTable = new DropTable(this.file, "Mob:" + this.internalName, list3, true);
            List<String> equipment = mc.getStringList("Equipment");
            this.equipmentTable = new DropTable(this.file, "MobEquipment:" + this.internalName, equipment, true);
            List<String> lstDamageMod = mc.getStringList("DamageModifiers");
            this.damageModifiers = new HashMap<String, Double>();
            if (lstDamageMod != null && lstDamageMod.size() > 0) {
                for (String string : lstDamageMod) {
                    try {
                        String[] split = string.split(" ");
                        String type = split[0];
                        double mod = Double.valueOf(split[1]);
                        this.damageModifiers.put(type, mod);
                    }
                    catch (Exception ex) {
                        MythicLogger.errorMobConfig(this, mc, "Invalid syntax for DamageModifier");
                    }
                }
            }
            List<String> lstEntDamageMod = mc.getStringList("EntityDamageModifiers");
            this.entityDamageModifiers = new HashMap<String, Double>();
            if (lstEntDamageMod != null && lstEntDamageMod.size() > 0) {
                for (String dm : lstEntDamageMod) {
                    try {
                        String[] split = dm.split(" ");
                        String type = split[0];
                        double mod = Double.valueOf(split[1]);
                        this.entityDamageModifiers.put(type, mod);
                    }
                    catch (Exception ex) {
                        MythicLogger.errorMobConfig(this, mc, "Invalid syntax for DamageModifier");
                    }
                }
            }
            if ((list = mc.getStringList("KillMessages")) != null && list.size() > 0) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Loading mob kill messages...", new Object[0]);
                if (this.killMessages == null) {
                    this.killMessages = new ArrayList<PlaceholderString>();
                }
                list.forEach(message -> this.killMessages.add(PlaceholderString.of(message)));
            }
            this.lvlModDamage = mc.getDouble("LevelModifiers.Damage", -1.0);
            this.lvlModHealth = mc.getDouble("LevelModifiers.Health", -1.0);
            this.lvlModKBR = mc.getDouble("LevelModifiers.KnockbackResistance", -1.0);
            this.lvlModPower = mc.getDouble("LevelModifiers.Power", -1.0);
            this.lvlModArmor = mc.getDouble("LevelModifiers.Armor", -1.0);
            this.lvlModSpeed = mc.getDouble("LevelModifiers.MovementSpeed", -1.0);
            this.lvlModAttackSpeed = mc.getDouble("LevelModifiers.AttackSpeed", -1.0);
            if (this.attrDamage.isStatic()) {
                try {
                    if (this.lvlModDamage < 0.0) {
                        this.lvlModDamage = ConfigManager.defaultLevelModifierDamage.startsWith("+") ? Double.valueOf(ConfigManager.defaultLevelModifierDamage.substring(1)) : (ConfigManager.defaultLevelModifierDamage.startsWith("*") ? this.attrDamage.get() * Double.valueOf(ConfigManager.defaultLevelModifierDamage.substring(1)) : this.attrDamage.get() * Double.valueOf(ConfigManager.defaultLevelModifierDamage));
                    }
                }
                catch (Exception ex) {
                    MythicLogger.error("Error calculating Damage Level Modifier: Default configuration is bad.", ex);
                }
            }
            if (this.attrHealth.isStatic()) {
                try {
                    if (this.lvlModHealth < 0.0) {
                        this.lvlModHealth = ConfigManager.defaultLevelModifierHealth.startsWith("+") ? Double.valueOf(ConfigManager.defaultLevelModifierHealth.substring(1)) : (ConfigManager.defaultLevelModifierHealth.startsWith("*") ? this.attrHealth.get() * Double.valueOf(ConfigManager.defaultLevelModifierHealth.substring(1)) : this.attrHealth.get() * Double.valueOf(ConfigManager.defaultLevelModifierHealth));
                    }
                }
                catch (Exception ex) {
                    MythicLogger.error("Error calculating Health Level Modifier: Default configuration is bad.", ex);
                }
            }
            try {
                if (this.lvlModPower < 0.0) {
                    this.lvlModPower = ConfigManager.defaultLevelModifierPower.startsWith("+") ? Double.valueOf(ConfigManager.defaultLevelModifierPower.substring(1)) : (ConfigManager.defaultLevelModifierPower.startsWith("*") ? Double.valueOf(ConfigManager.defaultLevelModifierPower.substring(1)).doubleValue() : Double.valueOf(ConfigManager.defaultLevelModifierPower).doubleValue());
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Error calculating Power Level Modifier: Default configuration is bad.", ex);
            }
            if (this.attrArmor.isStatic()) {
                try {
                    if (this.lvlModArmor < 0.0) {
                        this.lvlModArmor = ConfigManager.defaultLevelModifierArmor.startsWith("+") ? Double.valueOf(ConfigManager.defaultLevelModifierArmor.substring(1)) : (ConfigManager.defaultLevelModifierArmor.startsWith("*") ? this.attrArmor.get() * Double.valueOf(ConfigManager.defaultLevelModifierArmor.substring(1)) : Double.valueOf(ConfigManager.defaultLevelModifierArmor));
                    }
                }
                catch (Exception ex) {
                    MythicLogger.error("Error calculating Armor Level Modifier: Default configuration is bad.", ex);
                }
            }
            try {
                if (this.lvlModKBR < 0.0) {
                    this.lvlModKBR = ConfigManager.defaultLevelModifierKBR.startsWith("+") ? Double.valueOf(ConfigManager.defaultLevelModifierKBR.substring(1)) : (ConfigManager.defaultLevelModifierKBR.startsWith("*") ? this.attrKnockbackResist * Double.valueOf(ConfigManager.defaultLevelModifierKBR.substring(1)) : Double.valueOf(ConfigManager.defaultLevelModifierKBR));
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Error calculating KBR Level Modifier: Default configuration is bad.");
                if (ConfigManager.debugLevel <= 0) break block83;
                ex.printStackTrace();
            }
        }
        this.digOutOfGround = mc.getBoolean("Options.DigOutOfGround", false);
        String strSpawnVelocityX = mc.getString("SpawnModifiers.VelocityX", "0");
        String strSpawnVelocityY = mc.getString("SpawnModifiers.VelocityY", "0");
        String strSpawnVelocityZ = mc.getString("SpawnModifiers.VelocityZ", "0");
        if (strSpawnVelocityX.contains("to")) {
            String[] split = strSpawnVelocityX.split("to");
            try {
                this.spawnVelocityX = Double.valueOf(split[0]);
                this.spawnVelocityXMax = Double.valueOf(split[1]);
                this.spawnVelocityXRange = true;
            }
            catch (Exception ex) {
                this.spawnVelocityX = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityX.", this.internalName);
            }
        } else {
            try {
                this.spawnVelocityX = Double.valueOf(strSpawnVelocityX);
            }
            catch (Exception ex) {
                this.spawnVelocityX = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityX.", this.internalName);
            }
        }
        if (strSpawnVelocityY.contains("to")) {
            String[] split = strSpawnVelocityY.split("to");
            try {
                this.spawnVelocityY = Double.valueOf(split[0]);
                this.spawnVelocityYMax = Double.valueOf(split[1]);
                this.spawnVelocityYRange = true;
            }
            catch (Exception ex) {
                this.spawnVelocityY = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityY.", this.internalName);
            }
        } else {
            try {
                this.spawnVelocityY = Double.valueOf(strSpawnVelocityY);
            }
            catch (Exception ex) {
                this.spawnVelocityY = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityY.", this.internalName);
            }
        }
        if (strSpawnVelocityZ.contains("to")) {
            String[] split = strSpawnVelocityZ.split("to");
            try {
                this.spawnVelocityZ = Double.valueOf(split[0]);
                this.spawnVelocityZMax = Double.valueOf(split[1]);
                this.spawnVelocityZRange = true;
            }
            catch (Exception ex) {
                this.spawnVelocityZ = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityZ.", this.internalName);
            }
        } else {
            try {
                this.spawnVelocityZ = Double.valueOf(strSpawnVelocityZ);
            }
            catch (Exception ex) {
                this.spawnVelocityZ = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityZ.", this.internalName);
            }
        }
        this.disguise = mc.getString("Options.Disguise", this.disguise);
        this.disguise = mc.getString("Disguise.Type", this.disguise);
        if (this.disguise != null) {
            this.legacyDisguise = true;
            if (this.disguise.toUpperCase().contains("PLAYER")) {
                this.fakePlayer = true;
            }
        } else if (mc.isSet("Disguise")) {
            this.disguise = mc.getString("Disguise", null);
            if (this.disguise != null) {
                this.legacyDisguise = false;
            }
        }
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public ActiveMob spawn(AbstractLocation location, double level) {
        return this.spawn(location, level, SpawnReason.OTHER);
    }

    public ActiveMob spawn(AbstractLocation location, double level, SpawnReason reason) {
        Entity e;
        block9: {
            MythicMob.getMobManager();
            MobManager.spawnflag = true;
            try {
                if (this.mPetType.isPresent()) {
                    e = this.mPetType.get().spawn(location);
                    break block9;
                }
                if (this.mobType != null) {
                    e = BukkitAdapter.adapt(this.mobType.spawn(location, reason));
                    break block9;
                }
                return null;
            }
            catch (Exception ex) {
                MythicLogger.errorMobConfig(this, this.config, "Mob type may not be supported on this version of Minecraft. Enable debugging for more information.");
                MythicMob.getPlugin().getConfiguration();
                if (ConfigManager.debugLevel > 0) {
                    ex.printStackTrace();
                }
                return null;
            }
            catch (Error ex) {
                MythicLogger.errorMobConfig(this, this.config, "Mob type may not be supported on this version of Minecraft. Enable debugging for more information.");
                MythicMob.getPlugin().getConfiguration();
                if (ConfigManager.debugLevel > 0) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        ActiveMob am = new ActiveMob(e.getUniqueId(), BukkitAdapter.adapt(e), this, 0.0);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Calling MythicMobSpawnEvent for " + this.getInternalName() + " (level: " + level + ")", new Object[0]);
        MythicMobSpawnEvent event = new MythicMobSpawnEvent(am, level);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            e.remove();
            return null;
        }
        level = event.getMobLevel();
        am.setLevel(level);
        MythicMob.getMobManager().registerActiveMob(am);
        am = this.applyMobOptions(am, level);
        am = this.applyMobVolatileOptions(am);
        am = this.applySpawnModifiers(am);
        if (this.hasSkills(SkillTrigger.SPAWN)) {
            new TriggeredSkill(SkillTrigger.SPAWN, am, null, new Pair[0]);
        }
        MythicMob.getPlugin().getMobManager();
        MobManager.spawnflag = false;
        return am;
    }

    public ActiveMob applyMobOptions(ActiveMob am, double level) {
        Entity entity = am.getEntity().getBukkitEntity();
        if (am.getEntity().isLiving()) {
            double movementSpeed;
            double damage;
            LivingEntity asLiving;
            block29: {
                double health;
                asLiving = (LivingEntity)entity;
                if (asLiving.isDead()) {
                    entity.remove();
                    am.unregisterSync();
                    return am;
                }
                if (!this.optionDespawn) {
                    asLiving.setRemoveWhenFarAway(false);
                }
                if (this.alwaysShowName) {
                    asLiving.setCustomNameVisible(true);
                }
                if (this.preventItemPickup.booleanValue()) {
                    asLiving.setCanPickupItems(false);
                }
                if (this.applyInvisibility.booleanValue()) {
                    asLiving.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false, false));
                }
                if ((health = this.getHealth(am)) > 0.0) {
                    try {
                        asLiving.setMaxHealth(health);
                        asLiving.setHealth(health);
                        if (this.mPetType.isPresent()) {
                            Schedulers.sync().runLater(() -> {
                                if (!asLiving.isDead()) {
                                    asLiving.setMaxHealth(health);
                                    asLiving.setHealth(health);
                                }
                            }, 20L);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        MythicLogger.errorMobConfig(this, this.config, "Mob HP is greater than server's maxHealth setting. Please modify spigot.yml and increase the maxHealth attribute to compensate.");
                        if (ConfigManager.debugLevel <= 0) break block29;
                        ex.printStackTrace();
                    }
                }
            }
            if ((damage = this.getDamage(am)) > 0.0) {
                if (asLiving.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE) != null) {
                    asLiving.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(am.getDamage());
                }
                if (CompatibilityManager.Heroes != null) {
                    CompatibilityManager.Heroes.setMobDamage(asLiving, am.getDamage());
                }
            }
            if ((movementSpeed = this.attrMovementSpeed.get(am)) != 0.0) {
                asLiving.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(this.getMovementSpeed(am));
            }
            if (this.attrAttackSpeed != 0.0 && asLiving.getAttribute(Attribute.GENERIC_ATTACK_SPEED) != null) {
                asLiving.getAttribute(Attribute.GENERIC_ATTACK_SPEED).setBaseValue(this.getAttackSpeed(level));
            }
            if (this.attrFollowRange != 0.0) {
                asLiving.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(this.attrFollowRange);
            }
            if (this.attrKnockbackResist != 0.0) {
                asLiving.getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE).setBaseValue(this.getKnockbackResistance(level));
            }
            if (!this.optionCollidable) {
                asLiving.setCollidable(false);
            }
            asLiving.setMaximumNoDamageTicks(this.noDamageTicks);
            if (entity instanceof Creature) {
                ActiveMob amm = am;
                Schedulers.sync().runLater(() -> {
                    EntityEquipment ee;
                    if (this.preventRandomEquipment.booleanValue()) {
                        ee = asLiving.getEquipment();
                        assert (ee != null);
                        ee.clear();
                        ee.setArmorContents(new ItemStack[]{new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR)});
                    }
                    this.equipmentTable.generate(new DropMetadata(amm, amm.getEntity())).equip(amm.getEntity());
                    ee = asLiving.getEquipment();
                    assert (ee != null);
                    ee.setItemInMainHandDropChance(0.0f);
                    ee.setItemInOffHandDropChance(0.0f);
                    ee.setHelmetDropChance(0.0f);
                    ee.setChestplateDropChance(0.0f);
                    ee.setLeggingsDropChance(0.0f);
                    ee.setBootsDropChance(0.0f);
                    if (this.useCustomNameplate) {
                        amm.setShowCustomNameplate(true);
                    }
                }, 5L);
            }
            if (this.getDisplayName() != null) {
                asLiving.setCustomName(am.getDisplayName());
            }
        }
        if (this.optionInvincible) {
            entity.setInvulnerable(true);
        }
        if (this.optionGlowing) {
            entity.setGlowing(true);
        }
        if (this.optionNoGravity) {
            entity.setGravity(false);
        }
        if (this.optionSilent) {
            entity.setSilent(true);
        }
        am.getEntity().setMetadata("mobname", this.getInternalName());
        am.getEntity().setMetadata("mythicmob", "true");
        if (this.mount.isPresent()) {
            MythicMob.getMobManager();
            if (!MobManager.mountflag && MythicMob.getMobManager().getMythicMob(this.mount.get()) != null) {
                MythicMob.getMobManager();
                MobManager.mountflag = true;
                if (entity.getVehicle() != null) {
                    entity.getVehicle().remove();
                }
                AbstractEntity mount = MythicMob.getMobManager().getMythicMob(this.mount.get()).spawn(am.getLocation(), level, SpawnReason.SUMMON).getEntity();
                MythicMob.getMobManager();
                MobManager.mountflag = false;
                mount.setPassenger(entity);
                ActiveMob mountInstance = MythicMob.getMobManager().getMythicMobInstance(mount);
                am.setMount(mountInstance);
                mountInstance.setParent(am);
            }
        }
        if (this.rider.isPresent()) {
            MythicMob.getMobManager();
            if (!MobManager.mountflag && MythicMob.getMobManager().getMythicMob(this.rider.get()) != null) {
                MythicMob.getMobManager();
                MobManager.mountflag = true;
                AbstractEntity rider = MythicMob.getMobManager().getMythicMob(this.rider.get()).spawn(am.getLocation(), level, SpawnReason.SUMMON).getEntity();
                MythicMob.getMobManager();
                MobManager.mountflag = false;
                rider.setPassenger(entity);
                ActiveMob riderInstance = MythicMob.getMobManager().getMythicMobInstance(rider);
                riderInstance.setMount(am);
                riderInstance.setParent(am);
            }
        }
        return am;
    }

    public ActiveMob applyMobVolatileOptions(ActiveMob am) {
        Entity e = am.getEntity().getBukkitEntity();
        if (this.hasFaction()) {
            e.setMetadata("Faction", (MetadataValue)new FixedMetadataValue((Plugin)MythicMob.getPlugin(), (Object)this.getFaction()));
        }
        if (am.getEntity().isCreature()) {
            if (this.optionNoAI) {
                am.getEntity().setAI(false);
            }
            if (ConfigManager.EnableAIModifiers) {
                if (this.getAIGoalSelectors() != null) {
                    MythicMob.getPlugin().getVolatileCodeHandler().getAIHandler().addPathfinderGoals((LivingEntity)e, this.getAIGoalSelectors());
                }
                if (this.getAITargetSelectors() != null) {
                    MythicMob.getPlugin().getVolatileCodeHandler().getAIHandler().addTargetGoals((LivingEntity)e, this.getAITargetSelectors());
                }
            }
        }
        if (this.disguise != null && CompatibilityManager.LibsDisguises != null) {
            CompatibilityManager.LibsDisguises.setDisguise(am, this.disguise, this.legacyDisguise);
        }
        return am;
    }

    public ActiveMob applySpawnModifiers(ActiveMob am) {
        double vl;
        AbstractEntity e = am.getEntity();
        AbstractVector v = e.getVelocity();
        if (this.spawnVelocityXRange) {
            vl = Numbers.randomDouble() * (this.spawnVelocityXMax - this.spawnVelocityX) + this.spawnVelocityX;
            v.setX(vl);
        } else {
            v.setX(this.spawnVelocityX);
        }
        if (this.spawnVelocityYRange) {
            vl = Numbers.randomDouble() * (this.spawnVelocityYMax - this.spawnVelocityY) + this.spawnVelocityY;
            v.setY(vl);
        } else {
            v.setY(this.spawnVelocityY);
        }
        if (this.spawnVelocityZRange) {
            vl = Numbers.randomDouble() * (this.spawnVelocityZMax - this.spawnVelocityZ) + this.spawnVelocityZ;
            v.setZ(vl);
        } else {
            v.setZ(this.spawnVelocityZ);
        }
        e.setVelocity(v);
        return am;
    }

    public void executeSkills(SkillTrigger cause, SkillMetadata data) {
        block8: {
            try {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Running Mechanics for ActiveMob {0} (uuid: {1})", this.internalName, data.getCaster().getEntity().getUniqueId());
                if (data.getCaster().getEntity() == null || !data.getCaster().getEntity().getWorld().isLoaded()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "! Mob is not loaded. Ignoring skills.", new Object[0]);
                    return;
                }
                if (data.getIsAsync()) {
                    for (SkillMechanic ms : this.getSkills(cause)) {
                        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Running Mechanics for ActiveMob '{0}' (uuid: {1})", this.internalName, data.getCaster().getEntity().getUniqueId());
                        if (ms.getRunAsync() || !ms.isUsableFromCaster(data)) continue;
                        ms.execute(data.deepClone().setIsAsync(false));
                    }
                    Schedulers.async().run(() -> {
                        for (SkillMechanic ms : this.getSkills(cause)) {
                            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Evaluating SkillMechanic {0}", ms.getConfigLine());
                            if (!ms.getRunAsync() || !ms.isUsableFromCaster(data)) continue;
                            ms.execute(data);
                        }
                    });
                } else {
                    for (SkillMechanic ms : this.getSkills(cause)) {
                        if (!ms.isUsableFromCaster(data)) continue;
                        ms.execute(data);
                    }
                }
            }
            catch (Error | Exception ex) {
                MythicLogger.errorMobConfig(this, this.config, "Error processing skills for mob " + this.internalName + ". Mob type may no longer exist, or may have become corrupted by a server crash, and will be removed.");
                if (ConfigManager.debugLevel > 0) {
                    ex.printStackTrace();
                }
                if (data.getCaster() == null || !(data.getCaster() instanceof ActiveMob)) break block8;
                MythicMob.getPlugin().getMobManager().unregisterActiveMob((ActiveMob)data.getCaster());
            }
        }
    }

    public void executeSignalSkill(String signal, SkillMetadata data) {
        SkillMechanic ms;
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Executing signal skills...", new Object[0]);
        if (this.signalSkills.containsKey(signal) && (ms = this.signalSkills.get(signal)).isUsableFromCaster(data)) {
            ms.execute(data);
        }
        for (SkillMechanic ms2 : this.getSkills(SkillTrigger.SIGNAL)) {
            if (!ms2.isUsableFromCaster(data)) continue;
            ms2.execute(data);
        }
    }

    public Queue<SkillMechanic> getSkills(SkillTrigger trigger) {
        if (this.hasCombatSkills && (trigger == SkillTrigger.SPAWN || trigger == SkillTrigger.ATTACK || trigger == SkillTrigger.DAMAGED || trigger == SkillTrigger.DEATH)) {
            Queue skills = this.skills.getOrDefault((Object)trigger, new LinkedList());
            skills.addAll((Collection)this.skills.get((Object)SkillTrigger.COMBAT));
            return skills;
        }
        return this.skills.getOrDefault((Object)trigger, new LinkedList());
    }

    public boolean hasSkills(SkillTrigger trigger) {
        return this.skills.containsKey((Object)trigger);
    }

    public Queue<SkillMechanic> getTimerSkills() {
        return this.timerSkills;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getFile() {
        return this.file;
    }

    public PlaceholderString getDisplayName() {
        return this.displayName;
    }

    public String getEntityType() {
        return this.strMobType;
    }

    public BukkitEntityType getMythicEntity() {
        return this.mobType;
    }

    public boolean getDespawns() {
        return this.optionDespawn;
    }

    public boolean isPersistent() {
        return this.optionPersistent;
    }

    public double getPerLevelHealth() {
        return this.lvlModHealth;
    }

    public double getPerLevelDamage() {
        return this.lvlModDamage;
    }

    public double getPerLevelPower() {
        return this.lvlModPower;
    }

    public PlaceholderDouble getArmor() {
        return this.attrArmor;
    }

    public double getPerLevelArmor() {
        return this.lvlModArmor;
    }

    protected double getArmor(ActiveMob am) {
        double level = am.getLevel();
        double attr = this.attrArmor.get(am);
        if (level > 1.0 && this.lvlModArmor > 0.0) {
            attr += this.lvlModArmor * (level - 1.0);
        }
        return attr;
    }

    public PlaceholderDouble getDamage() {
        return this.attrDamage;
    }

    public double getDamage(ActiveMob am) {
        double level = am.getLevel();
        double damage = this.attrDamage.get(am);
        if (this.lvlModDamage > 0.0) {
            if (level > 1.0) {
                damage += this.lvlModDamage * (level - 1.0);
            }
        } else if (MythicMob.getPlugin().getConfiguration().getScalingEquationDamage() != null) {
            damage = MythicMob.getPlugin().getConfiguration().getScalingEquationDamage().setVariable("v", damage).setVariable("l", am.getLevel()).evaluate();
        }
        return damage;
    }

    public double getMovementSpeed(ActiveMob am) {
        double level = am.getLevel();
        double attr = this.attrMovementSpeed.get(am);
        if (level > 1.0 && this.lvlModSpeed > 0.0) {
            attr += this.lvlModSpeed * (level - 1.0);
        }
        return attr;
    }

    public double getKnockbackResistance(double level) {
        double attr = this.attrKnockbackResist;
        if (level > 1.0 && this.lvlModKBR > 0.0) {
            attr += this.lvlModKBR * (level - 1.0);
        }
        return attr;
    }

    public double getAttackSpeed(double level) {
        double attr = this.attrAttackSpeed;
        if (level > 1.0 && this.lvlModAttackSpeed > 0.0) {
            attr += this.lvlModAttackSpeed * (level - 1.0);
        }
        return attr;
    }

    public boolean hasFaction() {
        return this.faction != null;
    }

    public String getFaction() {
        return this.faction;
    }

    public PlaceholderDouble getHealth() {
        return this.attrHealth;
    }

    public double getHealth(ActiveMob am) {
        double health = this.attrHealth.get(am);
        double level = am.getLevel();
        if (this.lvlModHealth > 0.0) {
            if (level > 1.0) {
                health += this.lvlModHealth * (level - 1.0);
            }
        } else if (MythicMob.getPlugin().getConfiguration().getScalingEquationHealth() != null) {
            health = MythicMob.getPlugin().getConfiguration().getScalingEquationHealth().setVariable("v", health).setVariable("l", am.getLevel()).evaluate();
        }
        return health;
    }

    public boolean getIsInvincible() {
        return this.optionInvincible;
    }

    public boolean usesThreatTable() {
        return this.useThreatTable;
    }

    public boolean usesImmunityTable() {
        return this.useImmunityTable;
    }

    public boolean getThreatTableUseDamageTaken() {
        return this.optionTTFromDamage;
    }

    public boolean getThreatTableDecaysUnreachable() {
        return this.optionTTDecayUnreachable;
    }

    public List<String> getLevelModifiers() {
        return this.levelmods;
    }

    public List<String> getAIGoalSelectors() {
        return this.aiGoalSelectors;
    }

    public List<String> getAITargetSelectors() {
        return this.aiTargetSelectors;
    }

    public boolean hasKillMessages() {
        return this.killMessages != null && this.killMessages.size() > 0;
    }

    public PlaceholderString getKillMessage() {
        if (!this.hasKillMessages()) {
            return null;
        }
        return this.killMessages.get(Numbers.randomInt(this.killMessages.size()));
    }

    public double getSpawnVelocityX() {
        return this.spawnVelocityX;
    }

    public double getSpawnVelocityY() {
        return this.spawnVelocityY;
    }

    public double getSpawnVelocityZ() {
        return this.spawnVelocityZ;
    }

    public boolean getIsInteractable() {
        return this.optionInteractable;
    }

    public boolean usesBossBar() {
        return this.useBossBar;
    }

    public int getBossBarRangeSquared() {
        return this.bossBarRangeSq;
    }

    public Optional<AbstractBossBar> getBossBar() {
        if (!this.useBossBar) {
            return Optional.empty();
        }
        AbstractBossBar bar = MythicMob.getPlugin().server().createBossBar(" ", this.bossBarColor, this.bossBarStyle);
        bar.setProgress(1.0);
        if (this.bossBarCreateFog) {
            bar.setCreateFog(true);
        }
        if (this.bossBarDarkenSky) {
            bar.setDarkenSky(true);
        }
        if (this.bossBarPlayMusic) {
            bar.setPlayBossMusic(true);
        }
        return Optional.of(bar);
    }

    public PlaceholderString getBossBarTitle() {
        return this.bossBarTitle;
    }

    public boolean equals(Object o) {
        if (o instanceof MythicMob) {
            return ((MythicMob)o).getInternalName().equals(this.internalName);
        }
        return false;
    }

    public String toString() {
        return "MythicMob{" + this.internalName + "}";
    }

    @Override
    public int compareTo(MythicMob mm3) {
        return this.internalName.compareTo(mm3.getInternalName());
    }

    public boolean getShowHealthInChat() {
        return this.optionShowHealthInChat;
    }

    public boolean getShowNameOnDamaged() {
        return this.showNameOnDamage;
    }

    public DropTable getDropTable() {
        return this.dropTable;
    }

    public DropTable getEquipmentTable() {
        return this.equipmentTable;
    }

    public Boolean getOptionLockPitch() {
        return this.optionLockPitch;
    }

    public Map<String, Double> getDamageModifiers() {
        return this.damageModifiers;
    }

    public Map<String, Double> getEntityDamageModifiers() {
        return this.entityDamageModifiers;
    }

    public boolean isUsingTimers() {
        return this.usingTimers;
    }

    public int getNoDamageTicks() {
        return this.noDamageTicks;
    }

    public int getMaxAttackRange() {
        return this.maxAttackRange;
    }

    public int getMaxAttackableRange() {
        return this.maxAttackableRange;
    }

    public int getMaxThreatDistance() {
        return this.maxThreatDistance;
    }

    public boolean isUseCustomNameplate() {
        return this.useCustomNameplate;
    }

    public Boolean getRepeatAllSkills() {
        return this.repeatAllSkills;
    }

    public Boolean getPreventOtherDrops() {
        return this.preventOtherDrops;
    }

    public Boolean getPreventRandomEquipment() {
        return this.preventRandomEquipment;
    }

    public Boolean getPreventLeashing() {
        return this.preventLeashing;
    }

    public Boolean getPreventRename() {
        return this.preventRename;
    }

    public Boolean getPreventSlimeSplit() {
        return this.preventSlimeSplit;
    }

    public Boolean getPreventEndermanTeleport() {
        return this.preventEndermanTeleport;
    }

    public Boolean getPreventItemPickup() {
        return this.preventItemPickup;
    }

    public Boolean getPreventSilverfishInfection() {
        return this.preventSilverfishInfection;
    }

    public Boolean getPreventSunburn() {
        return this.preventSunburn;
    }

    public Boolean getPreventExploding() {
        return this.preventExploding;
    }

    public Boolean getPreventMobKillDrops() {
        return this.preventMobKillDrops;
    }

    public Boolean getPreventTransformation() {
        return this.preventTransformation;
    }

    public Boolean getPreventJockeyMounts() {
        return this.preventJockeyMounts;
    }

    public Boolean getPassthroughDamage() {
        return this.passthroughDamage;
    }

    public Boolean getApplyInvisibility() {
        return this.applyInvisibility;
    }

    public Boolean getDigOutOfGround() {
        return this.digOutOfGround;
    }

    public Boolean getUsesHealthBar() {
        return this.usesHealthBar;
    }

    public double getSpawnVelocityXMax() {
        return this.spawnVelocityXMax;
    }

    public double getSpawnVelocityYMax() {
        return this.spawnVelocityYMax;
    }

    public double getSpawnVelocityZMax() {
        return this.spawnVelocityZMax;
    }

    public boolean isSpawnVelocityXRange() {
        return this.spawnVelocityXRange;
    }

    public boolean isSpawnVelocityYRange() {
        return this.spawnVelocityYRange;
    }

    public boolean isSpawnVelocityZRange() {
        return this.spawnVelocityZRange;
    }

    public String getDisguise() {
        return this.disguise;
    }

    public boolean isFakePlayer() {
        return this.fakePlayer;
    }

    public boolean isLegacyDisguise() {
        return this.legacyDisguise;
    }
}

