/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.legacy.conditions.SCondition;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.conditions.InvalidCondition;
import io.lumine.xikage.mythicmobs.skills.mechanics.DelaySkill;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;

public class Skill
extends AbstractSkill {
    protected final String file;
    protected final String internalName;
    protected final MythicConfig config;
    protected LinkedList<SkillMechanic> skills = new LinkedList();
    protected List<String> conditionsLegacy = new ArrayList<String>();
    protected List<String> killMessages;

    public Skill(String file, String name, MythicConfig mc) {
        SkillCondition sc;
        String ns;
        int i;
        String[] split;
        this.file = file;
        this.internalName = name;
        this.config = mc;
        this.cooldown = (float)mc.getDouble("Cooldown", 0.0);
        this.conditionsLegacy = mc.getStringList("LegacyConditions");
        List<String> nTConditions = mc.getStringList("Conditions");
        for (String s2 : nTConditions) {
            if (s2.contains("\"")) {
                split = s2.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if ((sc = SkillCondition.getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditions == null) {
                this.conditions = new ArrayList();
            }
            this.conditions.add(sc);
        }
        nTConditions = mc.getStringList("TargetConditions");
        for (String s2 : nTConditions) {
            if (s2.contains("\"")) {
                split = s2.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if ((sc = SkillCondition.getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditionsTarget == null) {
                this.conditionsTarget = new ArrayList();
            }
            this.conditionsTarget.add(sc);
        }
        nTConditions = mc.getStringList("TriggerConditions");
        for (String s2 : nTConditions) {
            if (s2.contains("\"")) {
                split = s2.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if ((sc = SkillCondition.getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditionsTrigger == null) {
                this.conditionsTrigger = new ArrayList();
            }
            this.conditionsTrigger.add(sc);
        }
        List<String> nSkills = mc.getStringList("Skills");
        for (String s3 : nSkills) {
            s3 = MythicLineConfig.unparseBlock(s3);
            SkillMechanic ms = null;
            try {
                ms = MythicMobs.inst().getSkillManager().getSkillMechanic(s3);
            }
            catch (Exception ex) {
                MythicLogger.errorGenericConfig("Critical Error while attempting to load mechanic line '" + s3 + "'");
            }
            catch (Error ex) {
                MythicLogger.errorGenericConfig("Critical Error while attempting to load mechanic line '" + s3 + "'");
            }
            if (ms == null) continue;
            this.skills.add(ms);
        }
    }

    public Skill(Collection<String> skillList) {
        this.file = "#\u03bb";
        this.internalName = "#\u03bb." + UUID.randomUUID().toString();
        this.config = null;
        this.cooldown = 0.0f;
        for (String s2 : skillList) {
            s2 = MythicLineConfig.unparseBlock(s2);
            SkillMechanic ms = null;
            try {
                ms = MythicMobs.inst().getSkillManager().getSkillMechanic(s2);
            }
            catch (Exception ex) {
                MythicLogger.errorGenericConfig("Critical Error while attempting to load mechanic line '" + s2 + "'");
            }
            catch (Error ex) {
                MythicLogger.errorGenericConfig("Critical Error while attempting to load mechanic line '" + s2 + "'");
            }
            if (ms == null) continue;
            this.skills.add(ms);
        }
    }

    public String getInternalName() {
        return this.internalName;
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public boolean usable(SkillMetadata meta, SkillTrigger trigger) {
        SkillCaster skillCaster = meta.getCaster();
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: Roll failed.", new Object[0]);
            return false;
        }
        if (this.onCooldown(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: Cooldown check failed.", new Object[0]);
            return false;
        }
        if (!this.checkLegacyConditions(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: Legacy check failed.", new Object[0]);
            return false;
        }
        if (this.conditionsTarget != null) {
            for (SkillCondition mc : this.conditionsTarget) {
                if (mc.evaluateTargets(meta)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: TargetConditions failed.", new Object[0]);
                return false;
            }
        }
        if (this.conditionsTrigger != null) {
            for (SkillCondition mc : this.conditionsTrigger) {
                if (mc.evaluateTrigger(meta)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: TriggerConditions failed.", new Object[0]);
                return false;
            }
        }
        if (this.conditions != null) {
            for (SkillCondition mc : this.conditions) {
                if (mc.evaluateCaster(meta)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: Conditions failed.", new Object[0]);
                return false;
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill usable!", new Object[0]);
        return true;
    }

    public void execute(SkillTrigger basetrigger, SkillCaster caster, AbstractEntity trigger, AbstractLocation origin, HashSet<AbstractEntity> eTargets, HashSet<AbstractLocation> lTargets, float power) {
        SkillMetadata data = new SkillMetadata(basetrigger, caster, trigger, origin, eTargets, lTargets, power);
        this.execute(data);
    }

    public void execute(SkillMetadata data) {
        block3: {
            LinkedList skillqueue = (LinkedList)this.skills.clone();
            try {
                if (this.isUsable(data)) {
                    Skill.execute(data, skillqueue);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Couldn't execute skill '" + this.internalName + "': Enable debugging for a stack trace.");
                MythicMobs.inst().getConfiguration();
                if (ConfigManager.debugLevel <= 0) break block3;
                ex.printStackTrace();
            }
        }
        this.setCooldown(data.getCaster(), this.cooldown);
    }

    public static void execute(SkillMetadata data, Queue<SkillMechanic> skillqueue) {
        while (skillqueue.size() > 0) {
            SkillMechanic mbs = skillqueue.poll();
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Evaluating SkillMechanic {0}", mbs.getConfigLine());
            if (mbs instanceof DelaySkill) {
                AbstractSkill.DelayedSkill ds = new AbstractSkill.DelayedSkill(data, skillqueue);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.inst(), (Runnable)ds, (long)((DelaySkill)mbs).getTicks());
                break;
            }
            if (!mbs.isUsableFromSkill(data)) continue;
            mbs.execute(data.deepClone());
        }
    }

    public boolean isUsable(SkillMetadata data) {
        return this.usable(data, null);
    }

    public boolean checkLegacyConditions(SkillCaster skillCaster) {
        if (this.conditionsLegacy.size() > 0) {
            for (String strCondition : this.conditionsLegacy) {
                String[] split = strCondition.split(" ");
                String conditionData = null;
                if (split.length > 1) {
                    conditionData = split[1];
                }
                if (SCondition.getSpawningConditionByName(split[0]).check(BukkitAdapter.adapt(skillCaster.getEntity().getLocation()), (LivingEntity)skillCaster.getEntity().getBukkitEntity(), conditionData)) continue;
                return false;
            }
        }
        return true;
    }

    public String getFile() {
        return this.file;
    }
}

