/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import com.google.common.collect.ImmutableMap;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.conditions.ConditionAction;
import io.lumine.xikage.mythicmobs.skills.conditions.ICasterCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityComparisonCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityLocationComparisonCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationComparisonCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ISkillMetaCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.InvalidCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.CustomCondition;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawnPoint;
import java.util.HashSet;
import java.util.Optional;

public class SkillCondition {
    protected String conditionVar = "0";
    protected ConditionAction ACTION = ConditionAction.REQUIRED;
    protected PlaceholderString actionVar = null;

    public static MythicMobs getPlugin() {
        return MythicMobs.inst();
    }

    public SkillCondition(String line) {
        String[] split = line.split(" ");
        if (split.length < 2) {
            return;
        }
        if (ConditionAction.isAction(split[1])) {
            this.ACTION = ConditionAction.valueOf(split[1].toUpperCase());
            if (split.length > 2) {
                this.actionVar = PlaceholderString.of(split[2]);
            }
        } else {
            this.conditionVar = split[1];
            if (split.length > 2 && ConditionAction.isAction(split[2])) {
                this.ACTION = ConditionAction.valueOf(split[2].toUpperCase());
                if (split.length > 3) {
                    this.actionVar = PlaceholderString.of(split[3]);
                }
            }
        }
    }

    public boolean evaluateEntity(AbstractEntity t) {
        SkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (condition instanceof IEntityCondition) {
            return condition.handleOutcome(t, ((IEntityCondition)((Object)condition)).check(t));
        }
        if (condition instanceof ILocationCondition) {
            return condition.handleOutcome(t, ((ILocationCondition)((Object)condition)).check(t.getLocation()));
        }
        return false;
    }

    public boolean evaluateToEntity(AbstractEntity base, AbstractEntity t) {
        SkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (condition instanceof IEntityCondition) {
            return condition.handleOutcome(t, ((IEntityCondition)((Object)condition)).check(t));
        }
        if (condition instanceof ILocationCondition) {
            return condition.handleOutcome(t, ((ILocationCondition)((Object)condition)).check(t.getLocation()));
        }
        if (condition instanceof IEntityComparisonCondition) {
            return condition.handleOutcome(t, ((IEntityComparisonCondition)((Object)condition)).check(base, t));
        }
        if (condition instanceof ILocationComparisonCondition) {
            return condition.handleOutcome(t, ((ILocationComparisonCondition)((Object)condition)).check(base.getLocation(), t.getLocation()));
        }
        if (this instanceof IEntityLocationComparisonCondition) {
            return condition.handleOutcome(t, ((IEntityLocationComparisonCondition)((Object)condition)).check(base, t.getLocation()));
        }
        return false;
    }

    public boolean evaluateCaster(SkillMetadata meta) {
        SkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (condition instanceof ISkillMetaCondition) {
            return condition.handleOutcome(meta, ((ISkillMetaCondition)((Object)condition)).check(meta));
        }
        if (condition instanceof ICasterCondition) {
            return condition.handleOutcome(meta, ((ICasterCondition)((Object)condition)).check(meta.getCaster()));
        }
        if (condition instanceof IEntityCondition) {
            return condition.handleOutcome(meta, ((IEntityCondition)((Object)condition)).check(meta.getCaster().getEntity()));
        }
        if (condition instanceof ILocationCondition) {
            return condition.handleOutcome(meta, ((ILocationCondition)((Object)condition)).check(meta.getCaster().getLocation()));
        }
        return false;
    }

    public boolean evaluateTrigger(SkillMetadata meta) {
        SkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (meta.getTrigger() == null) {
            return false;
        }
        if (this instanceof IEntityCondition) {
            return condition.handleOutcome(meta, ((IEntityCondition)((Object)condition)).check(meta.getTrigger()));
        }
        if (this instanceof IEntityComparisonCondition) {
            return condition.handleOutcome(meta, ((IEntityComparisonCondition)((Object)condition)).check(meta.getCaster().getEntity(), meta.getTrigger()));
        }
        if (this instanceof ILocationCondition) {
            return condition.handleOutcome(meta, ((ILocationCondition)((Object)condition)).check(meta.getTrigger().getLocation()));
        }
        if (this instanceof ILocationComparisonCondition) {
            return condition.handleOutcome(meta, ((ILocationComparisonCondition)((Object)condition)).check(meta.getCaster().getLocation(), meta.getTrigger().getLocation()));
        }
        if (this instanceof IEntityLocationComparisonCondition) {
            return condition.handleOutcome(meta, ((IEntityLocationComparisonCondition)((Object)condition)).check(meta.getCaster().getEntity(), meta.getTrigger().getLocation()));
        }
        return false;
    }

    public boolean evaluateTargets(SkillMetadata meta) {
        SkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (meta.getEntityTargets() != null && meta.getEntityTargets().size() > 0) {
            HashSet targets = (HashSet)meta.getEntityTargets().clone();
            targets.removeIf(target -> {
                if (target == null || target.isDead() || !target.isValid()) {
                    return true;
                }
                if (condition instanceof IEntityCondition) {
                    return !condition.handleOutcome(meta, ((IEntityCondition)((Object)condition)).check((AbstractEntity)target));
                }
                if (condition instanceof IEntityComparisonCondition) {
                    return !condition.handleOutcome(meta, ((IEntityComparisonCondition)((Object)condition)).check(meta.getCaster().getEntity(), (AbstractEntity)target));
                }
                if (condition instanceof ILocationCondition) {
                    return !condition.handleOutcome(meta, ((ILocationCondition)((Object)condition)).check(target.getLocation()));
                }
                if (condition instanceof ILocationComparisonCondition) {
                    return !condition.handleOutcome(meta, ((ILocationComparisonCondition)((Object)condition)).check(meta.getCaster().getLocation(), target.getLocation()));
                }
                if (this instanceof IEntityLocationComparisonCondition) {
                    return condition.handleOutcome(meta, ((IEntityLocationComparisonCondition)((Object)condition)).check(meta.getCaster().getEntity(), target.getLocation()));
                }
                return false;
            });
            meta.setEntityTargets(targets);
            if (targets.size() == 0) {
                return false;
            }
        } else if (meta.getLocationTargets() != null && meta.getLocationTargets().size() > 0) {
            HashSet targets = (HashSet)meta.getLocationTargets().clone();
            targets.removeIf(target -> {
                if (condition instanceof ILocationCondition) {
                    return !condition.handleOutcome(meta, ((ILocationCondition)((Object)condition)).check((AbstractLocation)target));
                }
                if (condition instanceof ILocationComparisonCondition) {
                    return !condition.handleOutcome(meta, ((ILocationComparisonCondition)((Object)condition)).check(meta.getCaster().getLocation(), (AbstractLocation)target));
                }
                if (this instanceof IEntityLocationComparisonCondition) {
                    return condition.handleOutcome(meta, ((IEntityLocationComparisonCondition)((Object)condition)).check(meta.getCaster().getEntity(), (AbstractLocation)target));
                }
                return false;
            });
            meta.setLocationTargets(targets);
            if (targets.size() == 0) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean evaluateRandomSpawnPoint(RandomSpawnPoint rsp) {
        SkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (condition instanceof IEntityCondition) {
            return condition.handleOutcome(rsp, ((IEntityCondition)((Object)condition)).check(rsp.getEntity()));
        }
        if (condition instanceof ILocationCondition) {
            return condition.handleOutcome(rsp, ((ILocationCondition)((Object)condition)).check(rsp.getLocation()));
        }
        return false;
    }

    public boolean evaluateDropper(DropMetadata meta) {
        if (!meta.getDropper().isPresent()) {
            return false;
        }
        SkillCaster dropper = meta.getDropper().get();
        SkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (condition instanceof ICasterCondition) {
            return condition.handleOutcome(meta, ((ICasterCondition)((Object)condition)).check(dropper));
        }
        if (condition instanceof IEntityCondition) {
            return condition.handleOutcome(meta, ((IEntityCondition)((Object)condition)).check(dropper.getEntity()));
        }
        if (condition instanceof ILocationCondition) {
            return condition.handleOutcome(meta, ((ILocationCondition)((Object)condition)).check(dropper.getLocation()));
        }
        return false;
    }

    public boolean evaluateDropCause(DropMetadata meta) {
        if (!meta.getCause().isPresent()) {
            return false;
        }
        AbstractEntity cause = meta.getCause().get();
        SkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (condition instanceof IEntityCondition) {
            return condition.handleOutcome(meta, ((IEntityCondition)((Object)condition)).check(cause));
        }
        if (condition instanceof ILocationCondition) {
            return condition.handleOutcome(meta, ((ILocationCondition)((Object)condition)).check(cause.getLocation()));
        }
        return false;
    }

    public boolean handleOutcome(AbstractEntity entity, boolean outcome) {
        switch (this.ACTION) {
            case CANCEL: 
            case FALSE: {
                return !outcome;
            }
            case REQUIRED: 
            case TRUE: {
                return outcome;
            }
        }
        return true;
    }

    public boolean handleOutcome(SkillMetadata meta, boolean outcome) {
        switch (this.ACTION) {
            case CAST: {
                Optional<Skill> maybeSkill;
                if (!outcome || !(maybeSkill = MythicMobs.inst().getSkillManager().getSkill(this.actionVar.get(meta))).isPresent() || !maybeSkill.get().isUsable(meta)) break;
                maybeSkill.get().execute(meta);
                break;
            }
            case CASTINSTEAD: {
                if (!outcome) break;
                Optional<Skill> maybeSkill = MythicMobs.inst().getSkillManager().getSkill(this.actionVar.get(meta));
                if (maybeSkill.isPresent() && maybeSkill.get().isUsable(meta)) {
                    maybeSkill.get().execute(meta);
                }
                return false;
            }
            case CANCEL: 
            case FALSE: {
                if (outcome && this.actionVar != null && meta.getCaster().getEntity().isPlayer()) {
                    meta.getCaster().getEntity().asPlayer().sendMessage(this.actionVar.get(meta));
                }
                return !outcome;
            }
            case POWER: {
                if (!outcome) break;
                try {
                    float powerMod = Float.valueOf(this.actionVar.get(meta)).floatValue();
                    meta.setPower(meta.getPower() * powerMod);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case REQUIRED: 
            case TRUE: {
                if (!outcome && this.actionVar != null && meta.getCaster().getEntity().isPlayer()) {
                    meta.getCaster().getEntity().asPlayer().sendMessage(this.actionVar.get(meta));
                }
                return outcome;
            }
        }
        return true;
    }

    public boolean handleOutcome(RandomSpawnPoint rsp, boolean outcome) {
        switch (this.ACTION) {
            case CANCEL: 
            case FALSE: {
                return !outcome;
            }
            case LEVEL: {
                try {
                    float levelMod = Float.valueOf(this.actionVar.get()).floatValue();
                    rsp.setLevelMod(levelMod);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case REQUIRED: 
            case TRUE: {
                return outcome;
            }
        }
        return true;
    }

    public boolean handleOutcome(DropMetadata meta, boolean outcome) {
        switch (this.ACTION) {
            case CANCEL: 
            case FALSE: {
                return !outcome;
            }
            case REQUIRED: 
            case TRUE: {
                return outcome;
            }
        }
        return true;
    }

    public void setAction(ConditionAction action) {
        this.ACTION = action;
    }

    public String getActionVar() {
        return this.actionVar.get();
    }

    public static SkillCondition getCondition(String condition) {
        if ((condition = MythicLineConfig.unparseBlock(condition)).contains("}")) {
            String ns;
            String sp1 = condition.substring(0, condition.indexOf("}"));
            String sp2 = condition.substring(condition.indexOf("}"));
            condition = ns = sp1.replace(" ", "") + sp2;
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, ": Normalized Condition string to: " + condition, new Object[0]);
        }
        String[] s2 = condition.split(" ");
        String name = null;
        MythicLineConfig mlc = new MythicLineConfig(s2[0]);
        name = s2[0].contains("{") ? s2[0].substring(0, s2[0].indexOf("{")) : s2[0];
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "? Matching MythicCondition type to " + name, new Object[0]);
        ImmutableMap<String, Class<? extends SkillCondition>> CONDITIONS = SkillCondition.getPlugin().getSkillManager().getConditions();
        if (CONDITIONS.containsKey(name.toUpperCase())) {
            Class clazz = (Class)CONDITIONS.get(name.toUpperCase());
            try {
                return (SkillCondition)clazz.getConstructor(String.class, MythicLineConfig.class).newInstance(condition, mlc);
            }
            catch (Exception e) {
                MythicLogger.error("Failed to construct condition {0}", condition);
                e.printStackTrace();
            }
        }
        try {
            return new CustomCondition(name, condition, mlc);
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to load condition '" + name + "'");
            ex.printStackTrace();
            return new InvalidCondition(condition);
        }
    }
}

