/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import com.google.common.collect.ImmutableMap;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.targeters.ConsoleTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.CustomTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.LivingInRadiusTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.LivingInWorldTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.LivingNearOriginTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.LivingNearTargetLocationTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.LocationTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.MPEntity;
import io.lumine.xikage.mythicmobs.skills.targeters.MPLocation;
import io.lumine.xikage.mythicmobs.skills.targeters.MPMeta;
import io.lumine.xikage.mythicmobs.skills.targeters.MobsInRadiusTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.MobsNearOriginTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.NearestPlayerTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.PassengerTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.PlayerLocationsInRadiusTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.PlayersInRingTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.PlayersInWorldTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.PlayersNearOriginTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.PlayersNearTargetLocationsTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.PlayersOnServerTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.ThreatTablePlayersTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.ThreatTableRandomTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.ThreatTableTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.VanillaTargeter;
import java.util.List;

public abstract class SkillTargeter {
    protected MythicLineConfig config;
    protected String targetConditionString;
    protected List<SkillCondition> targetConditions = null;

    protected static MythicMobs getPlugin() {
        return MythicMobs.inst();
    }

    public SkillTargeter(MythicLineConfig mlc) {
        this.config = mlc;
        this.targetConditionString = mlc.getString(new String[]{"targetconditions", "conditions", "cond", "c"}, "null", new String[0]);
        if (MythicMobs.isVolatile() && this.targetConditionString != null) {
            this.targetConditions = SkillTargeter.getPlugin().getSkillManager().getConditions(this.targetConditionString);
        }
    }

    public static SkillTargeter getMythicTargeter(String search, MythicLineConfig mlc) {
        if (search == null) {
            return null;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "? Matching MythicTargeter type to " + search, new Object[0]);
        ImmutableMap<String, Class<? extends SkillTargeter>> TARGETERS = SkillTargeter.getPlugin().getSkillManager().getTargeters();
        if (TARGETERS.containsKey(search.toUpperCase())) {
            Class clazz = (Class)TARGETERS.get(search.toUpperCase());
            try {
                return (SkillTargeter)clazz.getConstructor(MythicLineConfig.class).newInstance(mlc);
            }
            catch (Exception e) {
                MythicLogger.error("Failed to construct targeter {0}", search);
                e.printStackTrace();
            }
        }
        switch (search.toUpperCase()) {
            case "LIVINGINRADIUS": 
            case "ENTITIESINRADIUS": 
            case "LIVINGENTITIESINRADIUS": 
            case "ALLINRADIUS": 
            case "EIR": {
                return new LivingInRadiusTargeter(mlc);
            }
            case "LIVINGINWORLD": 
            case "ENTITIESINWORLD": 
            case "LIVINGENTITIESINWORLD": 
            case "ALLINWORLD": 
            case "EIW": {
                return new LivingInWorldTargeter(mlc);
            }
            case "LIVINGNEARTARGETLOCATION": 
            case "LNTL": 
            case "LIVINGENTITIESNEARTARGETLOCATION": {
                return new LivingNearTargetLocationTargeter(mlc);
            }
            case "LOCATION": 
            case "LOC": 
            case "L": {
                return new LocationTargeter(mlc);
            }
            case "MOBSINRADIUS": 
            case "MOBS": 
            case "MIR": {
                return new MobsInRadiusTargeter(mlc);
            }
            case "NEARESTPLAYER": {
                return new NearestPlayerTargeter(mlc);
            }
            case "PASSENGER": 
            case "RIDER": {
                return new PassengerTargeter(mlc);
            }
            case "PLAYERSNEARTARGETLOCATION": 
            case "PNTL": {
                return new PlayersNearTargetLocationsTargeter(mlc);
            }
            case "PLAYERLOCATIONSSINRADIUS": 
            case "LOCATIONRADIUS": 
            case "PLR": 
            case "PLIR": {
                return new PlayerLocationsInRadiusTargeter(mlc);
            }
            case "PLAYERSINRING": 
            case "PRING": {
                return new PlayersInRingTargeter(mlc);
            }
            case "PLAYERSINWORLD": 
            case "WORLD": {
                return new PlayersInWorldTargeter(mlc);
            }
            case "PLAYERSONSERVER": 
            case "SERVER": {
                return new PlayersOnServerTargeter(mlc);
            }
            case "THREATTABLE": 
            case "THREATTARGETS": 
            case "TT": {
                return new ThreatTableTargeter(mlc);
            }
            case "THREATTABLEPLAYERS": 
            case "PLAYERSINTHREATTABLE": 
            case "TTP": {
                return new ThreatTablePlayersTargeter(mlc);
            }
            case "THREATTABLERANDOMTARGET": 
            case "RANDOMTHREATTARGET": 
            case "RTT": {
                return new ThreatTableRandomTargeter(mlc);
            }
            case "PLAYERSNEARORIGIN": 
            case "PLAYERSNEARSOURCE": {
                return new PlayersNearOriginTargeter(mlc);
            }
            case "ENTITIESNEARORIGIN": 
            case "ENTITIESNEARSOURCE": 
            case "ENO": 
            case "NEARORIGIN": {
                return new LivingNearOriginTargeter(mlc);
            }
            case "MOBSNEARORIGIN": 
            case "MOBSNEARSOURCE": {
                return new MobsNearOriginTargeter(mlc);
            }
            case "PARENTENTITIES": 
            case "PE": {
                return new MPEntity(mlc);
            }
            case "PARENTLOCATIONS": 
            case "PL": {
                return new MPLocation(mlc);
            }
            case "PARENTMETA": 
            case "PM": {
                return new MPMeta(mlc);
            }
            case "CONSOLE": 
            case "NONE": {
                return new ConsoleTargeter(mlc);
            }
        }
        if (search.substring(1, 2).equals("[")) {
            switch (search.substring(0, 1).toLowerCase()) {
                case "p": 
                case "r": 
                case "a": 
                case "e": {
                    return new VanillaTargeter(mlc, mlc.getLine());
                }
            }
        }
        return new CustomTargeter(search.toUpperCase(), mlc);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

