/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedDouble;

@MythicCondition(author="Ashijin", name="distanceFromSpawn", aliases={}, description="Whether the distance from the world's spawn point to the target is within the given range")
public class DistanceFromSpawnCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="distance", aliases={"d"}, description="The distance to match")
    private PlaceholderString distance;

    public DistanceFromSpawnCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.distance = mlc.getPlaceholderString(new String[]{"distance", "d"}, this.conditionVar, new String[0]);
    }

    @Override
    public boolean check(AbstractLocation l) {
        double distanceSq = l.getWorld().getSpawnLocation().distanceSquared(l);
        return new RangedDouble(this.distance.get()).equalsSquared(distanceSq);
    }
}

