/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import java.util.Optional;

@MythicCondition(author="Ashijin", name="faction", aliases={}, version="4.9", description="Tests the target's faction")
public class FactionCondition
extends SkillCondition
implements IEntityCondition {
    private PlaceholderString faction;

    public FactionCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.faction = mlc.getPlaceholderString(new String[]{"faction", "f"}, this.conditionVar, new String[0]);
    }

    @Override
    public boolean check(AbstractEntity target) {
        String faction = this.faction.get(target);
        if (target.isPlayer()) {
            Optional<String> maybeFaction = FactionCondition.getPlugin().getPlayerManager().getFactionProvider().getFaction(target.asPlayer());
            if (!maybeFaction.isPresent()) {
                return false;
            }
            return maybeFaction.get().equals(faction);
        }
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(target);
        if (am == null) {
            return false;
        }
        if (!am.hasFaction()) {
            return false;
        }
        return am.getFaction().equals(faction);
    }
}

