/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityComparisonCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityLocationComparisonCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;

@MythicCondition(author="Ashijin", name="fieldOfView", aliases={"infieldofview", "fov"}, version="4.3", description="Tests if the target is within the given angle from where the caster is looking")
public class FieldOfViewCondition
extends SkillCondition
implements IEntityComparisonCondition,
IEntityLocationComparisonCondition {
    @MythicField(name="angle", aliases={"a"}, description="The angle of the FOV to check in")
    private double angle;
    @MythicField(name="rotation", aliases={"r"}, description="Rotates the FOV to check in")
    private double rotation;

    public FieldOfViewCondition(String line, MythicLineConfig mlc) {
        super(line);
        double a = mlc.getDouble(new String[]{"angle", "a"}, this.conditionVar == null ? 90.0 : Double.valueOf(this.conditionVar));
        this.angle = a / 2.0;
        this.rotation = mlc.getDouble(new String[]{"rotation", "r"}, 0.0);
    }

    @Override
    public boolean check(AbstractEntity entity, AbstractEntity target) {
        AbstractVector entityVector = entity.getEyeLocation().toVector();
        AbstractVector targetVector = target.getEyeLocation().toVector();
        AbstractVector headDirection = entity.getEyeLocation().getDirection();
        AbstractVector targetDirection = targetVector.subtract(entityVector).normalize();
        double targetAngle = Math.toDegrees(targetDirection.angle(headDirection));
        return targetAngle <= this.angle;
    }

    @Override
    public boolean check(AbstractEntity entity, AbstractLocation target) {
        AbstractVector entityVector = entity.getEyeLocation().toVector();
        AbstractVector targetVector = target.toVector();
        AbstractVector headDirection = entity.getEyeLocation().getDirection();
        AbstractVector targetDirection = targetVector.subtract(entityVector).normalize();
        double targetAngle = Math.toDegrees(targetDirection.angle(headDirection));
        return targetAngle <= this.angle;
    }
}

