/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ICasterCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedDouble;

@MythicCondition(author="Ashijin", name="level", aliases={}, description="Checks the target MythicMob's level")
public class LevelCondition
extends SkillCondition
implements ICasterCondition,
IEntityCondition {
    @MythicField(name="level", aliases={"l"}, description="The level range to match")
    private RangedDouble data;

    public LevelCondition(String line, MythicLineConfig config) {
        super(line);
        this.data = new RangedDouble(config.getString(new String[]{"level", "l"}, this.conditionVar, new String[0]));
    }

    @Override
    public boolean check(AbstractEntity target) {
        if (MythicMobs.inst().getMobManager().isActiveMob(target)) {
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(target);
            return this.data.equals(am.getLevel());
        }
        return true;
    }

    @Override
    public boolean check(SkillCaster caster) {
        return this.data.equals(caster.getLevel());
    }
}

