/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedDouble;

@MythicCondition(author="jaylawl", name="pitch", aliases={}, version="4.5", description="Checks if the pitch of the target entity is within a range")
public class PitchCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="pitch", aliases={"p"}, description="The number range to match")
    private RangedDouble pitch;

    public PitchCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.pitch = new RangedDouble(mlc.getString(new String[]{"pitch", "p"}, this.conditionVar, new String[0]));
    }

    @Override
    public boolean check(AbstractEntity e) {
        return this.pitch.equals(Float.valueOf(e.getBukkitEntity().getLocation().getPitch()));
    }
}

