/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedDouble;

@MythicCondition(author="Ashijin", name="playerKills", aliases={}, description="Matches how many players the target mob has killed")
public class PlayerKillsCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="kills", aliases={"k"}, description="The number range to match")
    private RangedDouble kills;

    public PlayerKillsCondition(String line, MythicLineConfig mlc) {
        super(line);
        String k = mlc.getString(new String[]{"kills", "k"}, "0", this.conditionVar);
        this.kills = new RangedDouble(k);
    }

    @Override
    public boolean check(AbstractEntity entity) {
        if (MythicMobs.inst().getMobManager().isActiveMob(entity)) {
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(entity);
            return this.kills.equals(am.getPlayerKills());
        }
        return false;
    }
}

