/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedDouble;
import org.bukkit.Bukkit;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

@MythicCondition(author="Ashijin", name="globalscore", aliases={"scoreglobal"}, description="Checks a global scoreboard value")
public class ScoreGlobalCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="objective", aliases={"o"}, description="The objective")
    private String obj = "";
    @MythicField(name="value", aliases={"v"}, description="The value to match")
    private RangedDouble val;

    public ScoreGlobalCondition(String line, MythicLineConfig mlc) {
        super(line);
        String val = "";
        if (this.conditionVar.split(";").length > 2) {
            String[] split = this.conditionVar.split(";");
            this.obj = split[0];
            val = split[1];
        }
        this.obj = mlc.getString(new String[]{"objective", "obj", "o"}, this.obj, new String[0]);
        this.val = new RangedDouble(mlc.getString(new String[]{"value", "val", "v"}, val, new String[0]));
    }

    @Override
    public boolean check(AbstractEntity target) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective objective = scoreboard.getObjective(this.obj);
        if (objective == null) {
            objective = scoreboard.registerNewObjective(this.obj, "dummy");
        }
        int score = objective.getScore("__GLOBAL__").getScore();
        return this.val.equals(score);
    }
}

