/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ISkillMetaCondition;
import io.lumine.xikage.mythicmobs.skills.variables.VariableCondition;
import io.lumine.xikage.mythicmobs.skills.variables.VariableRegistry;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedDouble;

@MythicCondition(author="Ashijin", name="variableInRange", aliases={"varinrange", "varrange"}, version="4.6", description="Checks if the given numeric variable is within a certain range.")
public class VariableInRangeCondition
extends VariableCondition
implements IEntityCondition,
ILocationCondition,
ISkillMetaCondition {
    @MythicField(name="value", aliases={"val", "v"}, description="A number range to match")
    private RangedDouble value;

    public VariableInRangeCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
        try {
            this.value = new RangedDouble(mlc.getString(new String[]{"value", "val", "v", "range", "r"}, null, new String[0]));
        }
        catch (Exception ex) {
            MythicLogger.errorConditionConfig(this, mlc, "Variable range must be set.");
            return;
        }
    }

    @Override
    public boolean check(AbstractEntity target) {
        VariableRegistry registry = VariableInRangeCondition.getPlugin().getVariableManager().getRegistry(this.scope, target);
        float compare = registry.getFloat(this.key);
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "VariableInRange: checking {0} == {1}", Float.valueOf(compare), this.value.toString());
        try {
            return this.value.equals(Float.valueOf(compare));
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to process VariableInRange condition.");
            if (ConfigManager.debugLevel > 0) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public boolean check(AbstractLocation target) {
        VariableRegistry registry = VariableInRangeCondition.getPlugin().getVariableManager().getRegistry(this.scope, target);
        float compare = registry.getFloat(this.key);
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "VariableInRange: checking {0} == {1}", Float.valueOf(compare), this.value.toString());
        try {
            return this.value.equals(Float.valueOf(compare));
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to process VariableInRange condition.");
            if (ConfigManager.debugLevel > 0) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public boolean check(SkillMetadata meta) {
        VariableRegistry registry = VariableInRangeCondition.getPlugin().getVariableManager().getRegistry(this.scope, meta, meta.getCaster().getEntity());
        float compare = registry.getFloat(this.key);
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "VariableInRange: checking {0} == {1}", Float.valueOf(compare), this.value.toString());
        try {
            return this.value.equals(Float.valueOf(compare));
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to process VariableInRange condition.");
            if (ConfigManager.debugLevel > 0) {
                ex.printStackTrace();
            }
            return false;
        }
    }
}

