/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.holograms.types.CastBar;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.chat.ColorString;
import java.util.Optional;
import org.bukkit.event.player.PlayerMoveEvent;

@MythicMechanic(author="Ashijin", name="cast", description="Casts a metaskill with various options")
public class CastMechanic
extends Aura
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    @MythicField(name="onCast", aliases={"oc"}, version="4.6", description="Skill to execute if the cast finishes successfully")
    protected Optional<Skill> onCastSkill = Optional.empty();
    @MythicField(name="onInterrupted", aliases={"oi"}, version="4.6", description="Skill to execute if the cast is interrupted")
    protected Optional<Skill> onInterruptedSkill = Optional.empty();
    @MythicField(name="onNoTarget", aliases={"ont"}, version="4.6", description="Skill to execute if no target is found")
    protected Optional<Skill> onNoTargetsSkill = Optional.empty();
    protected String onCastSkillName;
    protected String onInterruptedSkillName;
    protected String onNoTargetsSkillName;
    @MythicField(name="skillname", aliases={"sn"}, version="4.6", description="Display name of the spell in the cast bar")
    protected PlaceholderString spellName;
    @MythicField(name="showCastBar", aliases={"cb"}, defValue="true", version="4.6", description="Whether to show the cast bar. Requires a compatible hologram plugin.")
    protected boolean showCastBar;
    @MythicField(name="cancelOnMove", aliases={"com"}, defValue="false", version="4.6", description="Whether to cancel the aura if the caster moves")
    protected boolean cancelOnMove;
    protected String castingText;

    public CastMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.onCastSkillName = mlc.getString(new String[]{"oncastskill", "oncast", "oc"});
        this.onInterruptedSkillName = mlc.getString(new String[]{"oninterruptedskill", "oninterrupted", "oninterrupt", "oi"});
        this.onNoTargetsSkillName = mlc.getString(new String[]{"onnotargetsskill", "onnotargets", "onnotarget", "ont"});
        this.spellName = mlc.getPlaceholderString(new String[]{"skillname", "spellname", "sn"}, null, new String[0]);
        this.showCastBar = mlc.getBoolean(new String[]{"showcastbar", "castbar", "cb"}, true);
        this.cancelOnMove = mlc.getBoolean(new String[]{"cancelonmove", "com"}, false);
        this.auraName = Optional.of("#casting");
        this.charges = PlaceholderInt.of("1");
        this.maxStacks = PlaceholderInt.of("1");
        this.mergeAll = true;
        this.castingText = this.spellName == null ? ColorString.get("&eCasting...") : ColorString.get("&eCasting &6" + this.spellName.toString() + "&e...");
        CastMechanic.getPlugin().getSkillManager().queueSecondPass(() -> {
            if (this.onCastSkillName != null) {
                this.onCastSkill = CastMechanic.getPlugin().getSkillManager().getSkill(this.onCastSkillName);
            }
            if (this.onInterruptedSkillName != null) {
                this.onInterruptedSkill = CastMechanic.getPlugin().getSkillManager().getSkill(this.onInterruptedSkillName);
            }
            if (this.onNoTargetsSkillName != null) {
                this.onNoTargetsSkill = CastMechanic.getPlugin().getSkillManager().getSkill(this.onNoTargetsSkillName);
            }
        });
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new CastTracker(target, data);
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        new CastTracker(target, data);
        return true;
    }

    public void failNoTargets(SkillMetadata data) {
        if (this.onNoTargetsSkill == null) {
            return;
        }
        if (!this.onNoTargetsSkill.isPresent()) {
            return;
        }
        data = data.deepClone();
        data.setEntityTarget(data.getCaster().getEntity());
        if (this.onNoTargetsSkill.get().isUsable(data)) {
            this.onNoTargetsSkill.get().execute(data);
        }
    }

    public class CastTracker
    extends Aura.AuraTracker {
        private CastBar castBar;

        public CastTracker(AbstractEntity target, SkillMetadata data) {
            super((Aura)CastMechanic.this, data.getCaster(), target, data);
            this.castBar = null;
            this.start();
        }

        public CastTracker(AbstractLocation target, SkillMetadata data) {
            super((Aura)CastMechanic.this, data.getCaster(), target, data);
            this.castBar = null;
            this.start();
        }

        @Override
        public void auraStart() {
            if (CastMechanic.this.cancelOnMove && this.skillMetadata.getCaster().getEntity().isPlayer()) {
                this.components.accept(Events.subscribe(PlayerMoveEvent.class).handler(event -> {
                    if (event.getPlayer().getUniqueId().equals(this.getCasterUUID())) {
                        this.terminate();
                    }
                }));
            }
            if (CastMechanic.this.showCastBar) {
                if (!AbstractSkill.getPlugin().getHologramManager().isActive()) {
                    CastMechanic.this.showCastBar = false;
                }
                Schedulers.sync().run(() -> {
                    if (!this.hasTerminated()) {
                        this.castBar = AbstractSkill.getPlugin().getHologramManager().createCastBar(this, CastMechanic.this.castingText);
                        this.components.accept(this.castBar);
                    }
                });
            }
            this.executeAuraSkill(CastMechanic.this.onStartSkill, this.skillMetadata);
        }

        @Override
        public void auraTick() {
            if (CastMechanic.this.showCastBar && this.castBar != null) {
                this.castBar.setCastPercent((double)this.ticksRemaining / (double)this.startDuration);
            }
            this.executeAuraSkill(CastMechanic.this.onTickSkill, this.skillMetadata, true);
        }

        @Override
        public void auraStop() {
            if (this.ticksRemaining <= 0) {
                if (CastMechanic.this.showCastBar && this.castBar != null) {
                    this.castBar.setFinished();
                }
                this.onCast();
            } else {
                if (CastMechanic.this.showCastBar && this.castBar != null) {
                    this.castBar.setInterrupted();
                }
                this.onInterrupted();
            }
            if (CastMechanic.this.doEndSkillOnTerminate) {
                this.executeAuraSkill(CastMechanic.this.onEndSkill, this.skillMetadata);
            }
        }

        public void onCast() {
            this.executeAuraSkill(CastMechanic.this.onCastSkill, this.skillMetadata);
        }

        public void onInterrupted() {
            this.executeAuraSkill(CastMechanic.this.onInterruptedSkill, this.skillMetadata);
        }
    }
}

