/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="removeHeldItem", aliases={"consumeHeldItem", "takeHeldItem"}, description="Removes an amount of the target's held item")
public class ConsumeHeldItemMechanic
extends SkillMechanic
implements INoTargetSkill {
    private int amount;

    public ConsumeHeldItemMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.amount = mlc.getInteger(new String[]{"amount", "a"}, 1);
    }

    @Override
    public boolean cast(SkillMetadata data) {
        if (!data.getCaster().getEntity().isPlayer()) {
            return false;
        }
        Optional<Object> maybeHeld = data.getMetadata("used-slot");
        if (maybeHeld.isPresent()) {
            int itemSlot = (Integer)maybeHeld.get();
            Player player = (Player)BukkitAdapter.adapt(data.getCaster().getEntity());
            ItemStack item = player.getInventory().getItem(itemSlot);
            if (item != null) {
                int newAmount = item.getAmount() - this.amount;
                if (newAmount <= 0) {
                    ConsumeHeldItemMechanic.getPlugin().getVolatileCodeHandler().getItemHandler().destroyItem(item);
                    if (MythicMobs.inst().getCompatibility().getArtifacts().isPresent()) {
                        MythicMobs.inst().getCompatibility().getArtifacts().get().reparseWeapon(data.getCaster().getEntity().asPlayer());
                    }
                } else {
                    item.setAmount(newAmount);
                }
                player.updateInventory();
            }
            return true;
        }
        Player player = (Player)data.getCaster().getEntity().getBukkitEntity();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item != null) {
            int newAmount = item.getAmount() - this.amount;
            if (newAmount <= 0) {
                ConsumeHeldItemMechanic.getPlugin().getVolatileCodeHandler().getItemHandler().destroyItem(item);
                player.updateInventory();
                if (MythicMobs.inst().getCompatibility().getArtifacts().isPresent()) {
                    MythicMobs.inst().getCompatibility().getArtifacts().get().reparseWeapon(data.getCaster().getEntity().asPlayer());
                }
            } else {
                item.setAmount(newAmount);
            }
        }
        return true;
    }
}

