/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="currencyGive", aliases={"giveCurrency"}, description="Gives an amount of vault currency")
public class CurrencyGiveMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private PlaceholderDouble amount;

    public CurrencyGiveMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.amount = mlc.getPlaceholderDouble(new String[]{"amount", "a"}, 0.0, new String[0]);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return false;
        }
        if (CurrencyGiveMechanic.getPlugin().getCompatibility().getVault().isPresent()) {
            CurrencyGiveMechanic.getPlugin().getCompatibility().getVault().get().giveMoney(target.asPlayer(), this.amount.get(data, target));
        }
        return false;
    }
}

