/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.DropTable;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@MythicMechanic(author="Ashijin", name="equip", description="Causes the caster to equip an item or droptable")
public class EquipMechanic
extends SkillMechanic
implements INoTargetSkill {
    private String equipString;
    private List<String> equipment = new ArrayList<String>();
    private DropTable equipmentTable;

    public EquipMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.equipString = mlc.getString(new String[]{"items", "item", "i", "equipment", "equip", "e"}, null, new String[0]);
        if (this.equipString.startsWith("\"")) {
            try {
                this.equipString = this.equipString.substring(1, this.equipString.length() - 1);
            }
            catch (Exception ex) {
                MythicLogger.errorMechanicConfig(this, mlc, "The 'items' attribute is required.");
            }
            this.equipString = SkillString.parseMessageSpecialChars(this.equipString);
        }
        this.equipment.addAll(Arrays.asList(this.equipString.split(",")));
        this.equipmentTable = new DropTable("EquipMechanic", "EquipMechanic", this.equipment);
    }

    @Override
    public boolean cast(SkillMetadata data) {
        this.equipmentTable.generate(new DropMetadata(data.getCaster(), data.getCaster().getEntity())).equip(data.getCaster().getEntity());
        return true;
    }
}

