/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="heal", aliases={"h"}, description="Heals the target entity")
public class HealMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderDouble amount;
    protected boolean overheal;
    protected PlaceholderDouble maxOverheal;

    public HealMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        String strAmount = mlc.getString(new String[]{"amount", "a"}, "1", new String[0]);
        this.amount = PlaceholderDouble.of(strAmount);
        this.overheal = mlc.getBoolean(new String[]{"overheal", "oh"}, false);
        this.maxOverheal = PlaceholderDouble.of(mlc.getString(new String[]{"maxoverheal", "maxabsorb", "maxshield", "mo", "ma", "ms"}, strAmount, new String[0]));
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead()) {
            return false;
        }
        double health = target.getHealth() + this.amount.get(data, target);
        if (health >= target.getMaxHealth()) {
            if (this.overheal) {
                double diff = health - target.getMaxHealth();
                double absorb = (double)MythicMobs.inst().getVolatileCodeHandler().getEntityHandler().getEntityAbsorptionHearts(target) + diff;
                if (absorb < this.maxOverheal.get(data, target)) {
                    MythicMobs.inst().getVolatileCodeHandler().getEntityHandler().setEntityAbsorptionHearts(target, (float)absorb);
                }
            }
            target.setHealth(target.getMaxHealth());
        } else {
            target.setHealth(health);
        }
        return true;
    }
}

