/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

@MythicMechanic(author="Ashijin", name="jump", description="Causes the caster to jump")
public class JumpMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected float velocity;

    public JumpMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.velocity = (float)mlc.getDouble("velocity", 1.0);
        this.velocity = (float)mlc.getDouble("v", (double)this.velocity);
    }

    @Override
    public boolean cast(SkillMetadata data) {
        Entity entity = BukkitAdapter.adapt(data.getCaster().getEntity());
        Vector velocity = entity.getVelocity();
        velocity.setY(velocity.getY() + (double)this.velocity);
        if (velocity.length() > 4.0) {
            velocity = velocity.normalize().multiply(4);
        }
        if (Double.isNaN(velocity.getX())) {
            velocity.setX(0);
        }
        if (Double.isNaN(velocity.getY())) {
            velocity.setY(0);
        }
        if (Double.isNaN(velocity.getZ())) {
            velocity.setZ(0);
        }
        entity.setVelocity(velocity);
        return true;
    }
}

