/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="lunge", description="Causes the caster to lunge forward at the target")
public class LungeMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected PlaceholderDouble velocity;
    protected PlaceholderDouble velocityY;

    public LungeMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.velocity = mlc.getPlaceholderDouble(new String[]{"velocity", "v", "magnitude"}, 1.0, new String[0]);
        this.velocityY = mlc.getPlaceholderDouble(new String[]{"velocityy", "yvelocity", "vy", "yv"}, 0.01337f, new String[0]);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation());
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        double velocity = Math.abs(this.velocity.get(data));
        double velocityY = this.velocityY.get(data);
        AbstractLocation cL = data.getCaster().getEntity().getLocation();
        if (cL.distance2DSquared(target) == 0.0) {
            target = target.add(cL.getDirection().normalize().multiply(2));
        }
        AbstractVector v = target.toVector().subtract(cL.toVector()).normalize();
        if (velocityY != 0.01337) {
            v.setY(velocityY);
        }
        if ((v = v.multiply(velocity)).length() > 4.0) {
            v = v.normalize().multiply(4);
        }
        data.getCaster().getEntity().setVelocity(v);
        return true;
    }
}

