/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="message", aliases={"msg", "m"}, description="Sends a message to the target entity")
public class MessageMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected PlaceholderString message;

    public MessageMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.target_creative = true;
        try {
            this.message = mlc.getPlaceholderString(new String[]{"message", "msg", "m"}, null, new String[0]);
        }
        catch (Exception ex) {
            this.message = null;
            ex.printStackTrace();
        }
        if (this.message == null) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'message' attribute is required.");
            this.message = PlaceholderString.of("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded message skill with message {0}", this.message.toString());
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isPlayer()) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Sending message {0}", this.message);
            target.asPlayer().sendMessage(this.message.get(data, target));
            return true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Failed to send message to non-player", new Object[0]);
        return false;
    }
}

