/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.ModifyGlobalScoreMechanic;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import org.bukkit.Bukkit;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;

@MythicMechanic(author="Ashijin", name="modifytargetscore", aliases={"mts"}, description="")
public class ModifyTargetScoreMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderString objective;
    protected ModifyGlobalScoreMechanic.ModifyScoreAction action;
    protected PlaceholderString value;

    public ModifyTargetScoreMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.objective = PlaceholderString.of(mlc.getString(new String[]{"objective", "obj", "o"}, "", new String[0]));
        this.value = PlaceholderString.of(mlc.getString(new String[]{"value", "v"}));
        String strAction = mlc.getString(new String[]{"action", "a"}, "ADD", new String[0]);
        try {
            this.action = ModifyGlobalScoreMechanic.ModifyScoreAction.valueOf(strAction.toUpperCase());
        }
        catch (Exception ex) {
            this.action = ModifyGlobalScoreMechanic.ModifyScoreAction.ADD;
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        String fobjective = this.objective.get(data, target);
        int fvalue = Integer.valueOf(this.value.get(data, target));
        Objective objective = scoreboard.getObjective(fobjective);
        if (objective == null) {
            objective = scoreboard.registerNewObjective(fobjective, "dummy");
        }
        Score score = target.isPlayer() ? objective.getScore(target.asPlayer().getName()) : objective.getScore(target.getUniqueId().toString());
        score.setScore(this.applyModifier(score.getScore(), fvalue));
        return true;
    }

    protected int applyModifier(int score, int value) {
        if (this.action == ModifyGlobalScoreMechanic.ModifyScoreAction.SET) {
            score = value;
        } else if (this.action == ModifyGlobalScoreMechanic.ModifyScoreAction.ADD) {
            score += value;
        } else if (this.action == ModifyGlobalScoreMechanic.ModifyScoreAction.SUBTRACT) {
            score -= value;
        } else if (this.action == ModifyGlobalScoreMechanic.ModifyScoreAction.MULTIPLY) {
            score *= value;
        } else if (this.action == ModifyGlobalScoreMechanic.ModifyScoreAction.DIVIDE) {
            score /= value;
        } else if (this.action == ModifyGlobalScoreMechanic.ModifyScoreAction.MOD) {
            score %= value;
        }
        return score;
    }
}

