/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.numbers.RandomDouble;
import java.util.Optional;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.util.EulerAngle;

@MythicMechanic(author="Ashijin", name="posearmorstand", aliases={"armorstandpose"}, description="Poses the target armor stand")
public class PoseArmorStandMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private Optional<RandomDouble> headPoseP;
    private Optional<RandomDouble> headPoseY;
    private Optional<RandomDouble> headPoseA;
    private Optional<RandomDouble> bodyPoseP;
    private Optional<RandomDouble> bodyPoseY;
    private Optional<RandomDouble> bodyPoseA;
    private Optional<RandomDouble> lArmPoseP;
    private Optional<RandomDouble> lArmPoseY;
    private Optional<RandomDouble> lArmPoseA;
    private Optional<RandomDouble> rArmPoseP;
    private Optional<RandomDouble> rArmPoseY;
    private Optional<RandomDouble> rArmPoseA;
    private Optional<RandomDouble> lLegPoseP;
    private Optional<RandomDouble> lLegPoseY;
    private Optional<RandomDouble> lLegPoseA;
    private Optional<RandomDouble> rLegPoseP;
    private Optional<RandomDouble> rLegPoseY;
    private Optional<RandomDouble> rLegPoseA;

    public PoseArmorStandMechanic(String skill, MythicLineConfig mlc) {
        block23: {
            String rLegPose;
            block22: {
                String lLegPose;
                block21: {
                    String rArmPose;
                    block20: {
                        String lArmPose;
                        block19: {
                            String bodyPose;
                            block18: {
                                super(skill, mlc);
                                this.headPoseP = Optional.empty();
                                this.headPoseY = Optional.empty();
                                this.headPoseA = Optional.empty();
                                this.bodyPoseP = Optional.empty();
                                this.bodyPoseY = Optional.empty();
                                this.bodyPoseA = Optional.empty();
                                this.lArmPoseP = Optional.empty();
                                this.lArmPoseY = Optional.empty();
                                this.lArmPoseA = Optional.empty();
                                this.rArmPoseP = Optional.empty();
                                this.rArmPoseY = Optional.empty();
                                this.rArmPoseA = Optional.empty();
                                this.lLegPoseP = Optional.empty();
                                this.lLegPoseY = Optional.empty();
                                this.lLegPoseA = Optional.empty();
                                this.rLegPoseP = Optional.empty();
                                this.rLegPoseY = Optional.empty();
                                this.rLegPoseA = Optional.empty();
                                String headPose = mlc.getString(new String[]{"head", "h"}, null, new String[0]);
                                if (headPose != null) {
                                    try {
                                        String[] split = headPose.split(",");
                                        this.headPoseP = Optional.of(new RandomDouble(split[0]));
                                        this.headPoseY = Optional.of(new RandomDouble(split[1]));
                                        this.headPoseA = Optional.of(new RandomDouble(split[2]));
                                    }
                                    catch (Exception ex) {
                                        MythicLogger.error("ArmorStandPose Mechanic is configured incorrectly: must be in format: pitch,yaw,angle");
                                        if (ConfigManager.debugLevel <= 0) break block18;
                                        ex.printStackTrace();
                                    }
                                }
                            }
                            if ((bodyPose = mlc.getString(new String[]{"body", "b"}, null, new String[0])) != null) {
                                try {
                                    String[] split = bodyPose.split(",");
                                    this.bodyPoseP = Optional.of(new RandomDouble(split[0]));
                                    this.bodyPoseY = Optional.of(new RandomDouble(split[1]));
                                    this.bodyPoseA = Optional.of(new RandomDouble(split[2]));
                                }
                                catch (Exception ex) {
                                    MythicLogger.error("ArmorStandPose Mechanic is configured incorrectly: must be in format: pitch,yaw,angle");
                                    if (ConfigManager.debugLevel <= 0) break block19;
                                    ex.printStackTrace();
                                }
                            }
                        }
                        if ((lArmPose = mlc.getString(new String[]{"leftarm", "la"}, null, new String[0])) != null) {
                            try {
                                String[] split = lArmPose.split(",");
                                this.lArmPoseP = Optional.of(new RandomDouble(split[0]));
                                this.lArmPoseY = Optional.of(new RandomDouble(split[1]));
                                this.lArmPoseA = Optional.of(new RandomDouble(split[2]));
                            }
                            catch (Exception ex) {
                                MythicLogger.error("ArmorStandPose Mechanic is configured incorrectly: must be in format: pitch,yaw,angle");
                                if (ConfigManager.debugLevel <= 0) break block20;
                                ex.printStackTrace();
                            }
                        }
                    }
                    if ((rArmPose = mlc.getString(new String[]{"rightarm", "ra"}, null, new String[0])) != null) {
                        try {
                            String[] split = rArmPose.split(",");
                            this.rArmPoseP = Optional.of(new RandomDouble(split[0]));
                            this.rArmPoseY = Optional.of(new RandomDouble(split[1]));
                            this.rArmPoseA = Optional.of(new RandomDouble(split[2]));
                        }
                        catch (Exception ex) {
                            MythicLogger.error("ArmorStandPose Mechanic is configured incorrectly: must be in format: pitch,yaw,angle");
                            if (ConfigManager.debugLevel <= 0) break block21;
                            ex.printStackTrace();
                        }
                    }
                }
                if ((lLegPose = mlc.getString(new String[]{"leftleg", "ll"}, null, new String[0])) != null) {
                    try {
                        String[] split = lLegPose.split(",");
                        this.lLegPoseP = Optional.of(new RandomDouble(split[0]));
                        this.lLegPoseY = Optional.of(new RandomDouble(split[1]));
                        this.lLegPoseA = Optional.of(new RandomDouble(split[2]));
                    }
                    catch (Exception ex) {
                        MythicLogger.error("ArmorStandPose Mechanic is configured incorrectly: must be in format: pitch,yaw,angle");
                        if (ConfigManager.debugLevel <= 0) break block22;
                        ex.printStackTrace();
                    }
                }
            }
            if ((rLegPose = mlc.getString(new String[]{"rightleg", "rl"}, null, new String[0])) != null) {
                try {
                    String[] split = rLegPose.split(",");
                    this.rLegPoseP = Optional.of(new RandomDouble(split[0]));
                    this.rLegPoseY = Optional.of(new RandomDouble(split[1]));
                    this.rLegPoseA = Optional.of(new RandomDouble(split[2]));
                }
                catch (Exception ex) {
                    MythicLogger.error("ArmorStandPose Mechanic is configured incorrectly: must be in format: pitch,yaw,angle");
                    if (ConfigManager.debugLevel <= 0) break block23;
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        EulerAngle a;
        Entity entity = target.getBukkitEntity();
        if (!(entity instanceof ArmorStand)) {
            return false;
        }
        ArmorStand e = (ArmorStand)entity;
        if (this.headPoseP.isPresent()) {
            a = new EulerAngle((double)((float)this.headPoseP.get().get()), (double)((float)this.headPoseY.get().get()), (double)((float)this.headPoseA.get().get()));
            e.setHeadPose(a);
        }
        if (this.bodyPoseP.isPresent()) {
            a = new EulerAngle((double)((float)this.bodyPoseP.get().get()), (double)((float)this.bodyPoseY.get().get()), (double)((float)this.bodyPoseA.get().get()));
            e.setBodyPose(a);
        }
        if (this.lArmPoseP.isPresent()) {
            a = new EulerAngle((double)((float)this.lArmPoseP.get().get()), (double)((float)this.lArmPoseY.get().get()), (double)((float)this.lArmPoseA.get().get()));
            e.setLeftArmPose(a);
        }
        if (this.rArmPoseP.isPresent()) {
            a = new EulerAngle((double)((float)this.rArmPoseP.get().get()), (double)((float)this.rArmPoseY.get().get()), (double)((float)this.rArmPoseA.get().get()));
            e.setRightArmPose(a);
        }
        if (this.lLegPoseP.isPresent()) {
            a = new EulerAngle((double)((float)this.lLegPoseP.get().get()), (double)((float)this.lLegPoseY.get().get()), (double)((float)this.lLegPoseA.get().get()));
            e.setLeftLegPose(a);
        }
        if (this.rLegPoseP.isPresent()) {
            a = new EulerAngle((double)((float)this.rLegPoseP.get().get()), (double)((float)this.rLegPoseY.get().get()), (double)((float)this.rLegPoseA.get().get()));
            e.setRightLegPose(a);
        }
        return true;
    }
}

