/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

@MythicMechanic(author="Ashijin", name="pull", description="Pulls the target entity towards the caster")
public class PullMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected boolean toOrigin;
    protected PlaceholderDouble velocity;

    public PullMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.velocity = mlc.getPlaceholderDouble(new String[]{"velocity", "v"}, 1.0, new String[0]);
        this.toOrigin = mlc.getBoolean(new String[]{"toorigin", "to"}, false);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        double velocity = this.velocity.get(data, target) / 10.0;
        Location l = this.toOrigin ? BukkitAdapter.adapt(data.getOrigin()) : BukkitAdapter.adapt(data.getCaster().getEntity()).getLocation();
        Entity t = BukkitAdapter.adapt(target);
        double distance = l.distance(t.getLocation());
        double modxz = distance * 0.5 * velocity;
        double mody = distance * 0.34 * velocity;
        mody = l.getY() - target.getLocation().getY() != 0.0 ? mody * (Math.abs(l.getY() - target.getLocation().getY()) * 0.5) : mody;
        Vector v = t.getLocation().toVector().subtract(l.toVector()).normalize().multiply(velocity);
        v.setX(v.getX() * -1.0 * modxz);
        v.setZ(v.getZ() * -1.0 * modxz);
        v.setY(v.getY() * -1.0 * mody);
        if (v.length() > 4.0) {
            v = v.normalize().multiply(4);
        }
        if (Double.isNaN(v.getX())) {
            v.setX(0);
        }
        if (Double.isNaN(v.getY())) {
            v.setY(0);
        }
        if (Double.isNaN(v.getZ())) {
            v.setZ(0);
        }
        t.setVelocity(v);
        return true;
    }
}

