/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.numbers.RandomFloat;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ashijin", version="4.10", name="recoil", aliases={"effect:recoil", "e:recoil"}, description="Causes the player's screen to recoil")
public class RecoilEffect
extends SkillMechanic
implements ITargetedEntitySkill {
    @MythicField(name="duration", aliases={"d"}, version="4.8", description="How long the effect should last")
    private float recoil;
    private RandomFloat pitchMod;
    private RandomFloat yawMod;
    private float sneakingMod;
    private float sprintingMod;

    public RecoilEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.recoil = mlc.getFloat(new String[]{"recoil", "r"}, 1.0f);
        String pitchMod = mlc.getString(new String[]{"pitch", "p"}, "-10to10", new String[0]);
        String yawMod = mlc.getString(new String[]{"yaw", "y"}, "-0.25to0.25", new String[0]);
        this.sneakingMod = mlc.getFloat(new String[]{"sneaking", "sn"}, 0.75f);
        this.sprintingMod = mlc.getFloat(new String[]{"sprinting", "sp"}, 1.25f);
        this.pitchMod = new RandomFloat(pitchMod);
        this.yawMod = new RandomFloat(yawMod);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return false;
        }
        Player player = (Player)target.getBukkitEntity();
        float pitch = this.recoil * this.pitchMod.get();
        float yaw = this.yawMod.get();
        if (player.isSneaking()) {
            pitch *= this.sneakingMod;
        } else if (player.isSprinting()) {
            pitch *= this.sprintingMod;
        }
        RecoilEffect.getPlugin().getVolatileCodeHandler().getEntityHandler().setPlayerRotation(target.asPlayer(), yaw, pitch);
        return true;
    }
}

