/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="sendactionmessage", aliases={"actionmessage", "am"}, description="Send an Action Bar message to the target player")
public class SendActionMessageMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderString message;

    public SendActionMessageMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.target_creative = true;
        try {
            this.message = PlaceholderString.of(mlc.getString(new String[]{"message", "msg", "m"}));
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'message' attribute is required.");
            this.message = PlaceholderString.of("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
            ex.printStackTrace();
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isPlayer()) {
            String message = this.message.get(data, target);
            target.asPlayer().sendActionBarMessage(message);
            return true;
        }
        return false;
    }
}

