/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SendTitleMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderString title;
    protected PlaceholderString subtitle;
    protected int timeIn;
    protected int timeSt;
    protected int timeOt;

    public SendTitleMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.target_creative = true;
        try {
            this.title = PlaceholderString.of(mlc.getString(new String[]{"title", "t"}));
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'message' attribute is required.");
            this.title = PlaceholderString.of("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
            ex.printStackTrace();
        }
        try {
            this.subtitle = PlaceholderString.of(mlc.getString(new String[]{"subtitle", "st"}));
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'message' attribute is required.");
            this.subtitle = PlaceholderString.of("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
            ex.printStackTrace();
        }
        this.timeIn = mlc.getInteger("fadein", 1);
        this.timeIn = mlc.getInteger("fi", this.timeIn);
        this.timeSt = mlc.getInteger("duration", 1);
        this.timeSt = mlc.getInteger("d", this.timeSt);
        this.timeOt = mlc.getInteger("fadeout", 1);
        this.timeOt = mlc.getInteger("fo", this.timeOt);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        String t = this.title.get(data, target);
        String st = this.subtitle.get(data, target);
        Entity e = BukkitAdapter.adapt(target);
        if (e instanceof Player) {
            ((Player)e).sendTitle(t, st, this.timeIn, this.timeSt, this.timeOt);
            return true;
        }
        return false;
    }
}

