/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@MythicMechanic(author="Ashijin", name="sendtoast", version="2.8", aliases={"advancementmessage", "advmessage", "toastmessage", "toastmsg"}, description="Sends a message to the target player as an advancement")
public class SendToastMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    protected PlaceholderString message;
    private String icon;
    private String iconnbt;
    private String frame;

    public SendToastMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.target_creative = true;
        try {
            this.message = PlaceholderString.of(mlc.getString(new String[]{"message", "msg", "m"}));
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'message' attribute is required.");
            this.message = PlaceholderString.of("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
            ex.printStackTrace();
        }
        this.icon = "minecraft:" + mlc.getString(new String[]{"icon", "i"}, "diamond_sword", new String[0]).toLowerCase();
        this.iconnbt = mlc.getString(new String[]{"iconnbt", "nbt"}, null, new String[0]);
        this.frame = mlc.getString(new String[]{"frame", "f"}, "challenge", new String[0]);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isPlayer()) {
            NamespacedKey id = new NamespacedKey((Plugin)MythicMobs.inst(), "temp-" + UUID.randomUUID().toString());
            String advJSON = this.build(data, target);
            Bukkit.getUnsafe().loadAdvancement(id, advJSON);
            Player player = (Player)target.asPlayer().getBukkitEntity();
            Advancement advancement = Bukkit.getAdvancement((NamespacedKey)id);
            AdvancementProgress progress = player.getAdvancementProgress(advancement);
            if (!progress.isDone()) {
                for (String criteria : progress.getRemainingCriteria()) {
                    progress.awardCriteria(criteria);
                }
            }
            Schedulers.sync().runLater(() -> {
                if (progress.isDone()) {
                    for (String criteria : progress.getAwardedCriteria()) {
                        progress.revokeCriteria(criteria);
                    }
                }
                Bukkit.getUnsafe().removeAdvancement(id);
            }, 20L);
            return true;
        }
        return false;
    }

    private String build(SkillMetadata data, AbstractEntity target) {
        JsonObject json = new JsonObject();
        JsonObject icon = new JsonObject();
        JsonObject display = new JsonObject();
        JsonObject criteria = new JsonObject();
        JsonObject trigger = new JsonObject();
        icon.addProperty("item", this.icon);
        if (this.iconnbt != null) {
            icon.addProperty("nbt", this.iconnbt);
        }
        display.add("icon", icon);
        display.addProperty("title", this.message.get(data, target));
        display.addProperty("description", "MythicMobs Toast Message");
        display.addProperty("background", "minecraft:textures/gui/advancements/backgrounds/adventure.png");
        display.addProperty("frame", this.frame);
        display.addProperty("announce_to_chat", false);
        display.addProperty("show_toast", true);
        display.addProperty("hidden", true);
        trigger.addProperty("trigger", "minecraft:impossible");
        criteria.add("impossible", trigger);
        json.add("criteria", criteria);
        json.add("display", display);
        return gson.toJson(json);
    }
}

