/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;

public class SetMaxHealthMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private PlaceholderDouble amount;
    private Mode mode;

    public SetMaxHealthMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.amount = mlc.getPlaceholderDouble(new String[]{"amount", "a"}, 1.0, new String[0]);
        String mode = mlc.getString(new String[]{"mode", "m"}, "STATIC", new String[0]);
        try {
            this.mode = Mode.valueOf(mode.toUpperCase());
        }
        catch (Error | Exception ex) {
            this.mode = Mode.STATIC;
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid mode");
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isLiving()) {
            switch (this.mode) {
                case STATIC: {
                    target.setMaxHealth(this.amount.get(data, target));
                    break;
                }
                case SCALE: {
                    double newMaxHealth = this.amount.get(data, target);
                    double oldHealth = target.getHealth();
                    double oldMaxHealth = target.getMaxHealth();
                    double percent = oldHealth / oldMaxHealth;
                    double newHealth = newMaxHealth * percent;
                    target.setMaxHealth(newMaxHealth);
                    target.setHealth(newHealth);
                    break;
                }
            }
        }
        return true;
    }

    private static enum Mode {
        STATIC,
        SCALE;

    }
}

