/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ashijin", name="setspeed", description="Sets the speed attribute of the target entity")
public class SetSpeedMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected float speed;
    protected Type type;

    public SetSpeedMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        String strType = mlc.getString(new String[]{"type", "t"}, "WALK", new String[0]).toUpperCase();
        this.speed = mlc.getFloat(new String[]{"speed", "s", "amount", "a", "value", "v", "multiplier", "m"}, 1.0f);
        this.type = strType.contains("FLY") ? Type.FLYING : Type.WALKING;
        float defaultSpeed = this.type == Type.FLYING ? 0.1f : 0.2f;
        this.speed = 1.0f * defaultSpeed;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isPlayer()) {
            Player p = (Player)BukkitAdapter.adapt(target);
            if (this.type == Type.FLYING) {
                p.setFlySpeed(this.speed);
            } else {
                p.setWalkSpeed(this.speed);
            }
        } else if (target.isLiving()) {
            LivingEntity l = (LivingEntity)BukkitAdapter.adapt(target);
            if (this.type == Type.FLYING) {
                l.getAttribute(Attribute.GENERIC_FLYING_SPEED).setBaseValue((double)this.speed);
            } else {
                l.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue((double)this.speed);
            }
        }
        return true;
    }

    protected static enum Type {
        WALKING,
        FLYING;

    }
}

