/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.tasks.Task;
import org.bukkit.util.Vector;

@MythicMechanic(author="Ashijin", name="effect:spin", aliases={"spin", "e:spin"}, description="Forces the target entity to spin")
public class SpinEffect
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderInt duration;
    protected PlaceholderInt velocity;

    public SpinEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.duration = mlc.getPlaceholderInteger(new String[]{"duration", "d"}, 40, new String[0]);
        this.velocity = mlc.getPlaceholderInteger(new String[]{"velocity", "v"}, 18, new String[0]);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(target, this.duration.get(data, target), this.velocity.get(data, target));
        return true;
    }

    private class Animator
    implements Runnable {
        private AbstractEntity target;
        private float yaw;
        private int velocity;
        private int duration;
        private int iteration;
        private Task task;

        public Animator(AbstractEntity target, int duration, int velocity) {
            this(duration, velocity);
            this.target = target;
            this.yaw = target.getLocation().getYaw();
        }

        protected Animator(int duration, int velocity) {
            this.velocity = velocity;
            this.duration = duration;
            this.iteration = 0;
            this.task = Schedulers.sync().runRepeating(this, 0L, 1L);
        }

        @Override
        public void run() {
            if (this.iteration > this.duration) {
                this.task.terminate();
            } else {
                this.yaw = (this.yaw + (float)this.velocity) % 360.0f;
                AbstractLocation l = this.target.getLocation();
                Vector v = this.target.getBukkitEntity().getVelocity();
                v.setY(v.getY() + 0.01);
                l.setYaw(this.yaw);
                this.target.teleport(l);
                this.target.getBukkitEntity().setVelocity(v);
                ++this.iteration;
            }
        }
    }
}

