/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin/jaylawl", name="teleportto", aliases={"tpt", "teleportlocation", "tpl"}, description="Teleports the target entity to a location")
public class TeleportToMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    @MythicField(name="relative", aliases={"m"}, version="4.9", description="Wether to use relative teleportation. Default=false")
    private boolean relative;
    @MythicField(name="world", aliases={"w"}, version="?", description="Which world to teleport to. Only used it mode=absolute")
    protected PlaceholderString world;
    @MythicField(name="location", aliases={"loc", "l", "coordinates", "c"}, version="?", description="The coordinates to teleport to in format x,y,z.")
    private String coords;
    protected PlaceholderDouble x;
    protected PlaceholderDouble y;
    protected PlaceholderDouble z;
    @MythicField(name="yaw", aliases={"y"}, version="?", description="The yaw to be applied when teleporting. Acts as an offset when using mode=relative")
    protected PlaceholderDouble yaw;
    @MythicField(name="pitch", aliases={"p"}, version="?", description="The pitch to be applied when teleporting. Acts as an offset when using mode=relative")
    protected PlaceholderDouble pitch;
    @MythicField(name="origin", aliases={"o"}, version="4.9", description="Wether to base relative teleportation on the caster's or the target's location - Default=false")
    private boolean targetAsOrigin;

    public TeleportToMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.relative = mlc.getBoolean(new String[]{"relative", "r"}, false);
        this.targetAsOrigin = mlc.getBoolean(new String[]{"targetasorigin", "tao"}, false);
        this.world = mlc.getPlaceholderString(new String[]{"world", "w"}, null, new String[0]);
        this.yaw = mlc.getPlaceholderDouble(new String[]{"yaw", "y"}, 0.0, new String[0]);
        this.pitch = mlc.getPlaceholderDouble(new String[]{"pitch", "p"}, 0.0, new String[0]);
        this.coords = mlc.getString(new String[]{"location", "loc", "l", "coordinates", "c"}, null, new String[0]);
        if (this.coords != null) {
            String[] split = this.coords.split(",");
            try {
                this.x = PlaceholderDouble.of(split[0]);
                this.y = PlaceholderDouble.of(split[1]);
                this.z = PlaceholderDouble.of(split[2]);
            }
            catch (Exception ex) {
                MythicLogger.errorMechanicConfig(this, mlc, "The 'coordinates' attribute must be in the format c=x,y,z.");
                return;
            }
        }
        if (this.coords == null) {
            if (this.relative) {
                MythicLogger.errorMechanicConfig(this, mlc, "'Coordinates' field is required for using relative teleportation");
            } else if (this.world == null) {
                MythicLogger.errorMechanicConfig(this, mlc, "Either the 'coordinates' attribute or 'world' attribute is required.");
            }
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        AbstractLocation location;
        AbstractEntity caster = data.getCaster().getEntity();
        if (!this.relative) {
            location = this.world == null ? new AbstractLocation(target.getWorld(), this.x.get(data, target), this.y.get(data, target), this.z.get(data, target)) : (this.coords == null ? new AbstractLocation(MythicMobs.inst().server().getWorld(this.world.get(data, target)), target.getLocation().getX(), target.getLocation().getY(), target.getLocation().getZ()) : new AbstractLocation(MythicMobs.inst().server().getWorld(this.world.get(data, target)), this.x.get(data, target), this.y.get(data, target), this.z.get(data, target)));
            location.setYaw((float)this.yaw.get(data, target));
            location.setPitch((float)this.pitch.get(data, target));
        } else {
            location = this.targetAsOrigin ? target.getLocation() : caster.getLocation();
            location.add(this.x.get(data, target), this.y.get(data, target), this.z.get(data, target));
            location.setYaw(location.getYaw() + (float)this.yaw.get(data, target));
            location.setPitch(location.getPitch() + (float)this.pitch.get(data, target));
        }
        target.teleport(location);
        return true;
    }
}

