/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderFloat;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="throw", description="Throws the target entity")
public class ThrowMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderFloat velocity;
    protected PlaceholderFloat velocityY;

    public ThrowMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.velocity = mlc.getPlaceholderFloat(new String[]{"velocity", "v"}, 1.0f, new String[0]);
        this.velocityY = mlc.getPlaceholderFloat(new String[]{"velocityy", "yvelocity", "vy", "yv"}, 1.0f, new String[0]);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        float velocity = this.velocity.get(data, target) / 10.0f;
        float velocityY = this.velocityY.get(data, target) / 10.0f;
        SkillAdapter.get().throwSkill(data.getCaster().getLocation(), target, velocity, velocityY);
        return true;
    }
}

