/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.projectiles.Projectile;
import io.lumine.xikage.mythicmobs.skills.projectiles.ProjectileHitBox;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import java.util.HashSet;

@MythicMechanic(author="Ashijin", name="totem", aliases={"toteme", "t"}, description="Creates a static totem projectile at the target")
public class TotemMechanic
extends Projectile
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected int maxCharges;
    protected float YOffset;

    public TotemMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.maxCharges = mlc.getInteger(new String[]{"charges", "ch", "c"}, 0);
        this.YOffset = mlc.getFloat(new String[]{"yoffset", "yo"}, 1.0f);
        this.stopOnHitEntity = mlc.getBoolean(new String[]{"stopatentity", "se"}, false);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        try {
            new TotemTracker(data, target.getLocation());
            return true;
        }
        catch (Exception ex) {
            MythicLogger.error("An error occurred executing a Totem Mechanic", ex);
            return false;
        }
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        try {
            new TotemTracker(data, target);
            return true;
        }
        catch (Exception ex) {
            MythicLogger.error("An error occurred executing a Totem Mechanic", ex);
            return false;
        }
    }

    private class TotemTracker
    extends Projectile.ProjectileTracker {
        private AbstractLocation position;
        private int charges;

        public TotemTracker(SkillMetadata data, AbstractLocation target) {
            super(TotemMechanic.this, data, target);
            this.position = target;
            this.charges = TotemMechanic.this.maxCharges;
            this.start();
        }

        @Override
        public void projectileStart() {
            this.startLocation = this.position;
            this.currentLocation = this.position;
            if (TotemMechanic.this.YOffset != 0.0f) {
                this.currentLocation.setY(this.currentLocation.getY() + (double)TotemMechanic.this.YOffset);
            }
        }

        @Override
        public void projectileTick() {
            if (this.bullet != null) {
                if (TotemMechanic.this.bulletType == Projectile.BulletType.ITEM) {
                    AbstractLocation ol = this.currentLocation.clone();
                    AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, ol);
                    this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.previousLocation.toVector()));
                } else if (TotemMechanic.this.bulletType == Projectile.BulletType.MOB) {
                    AbstractLocation ol = this.currentLocation.clone();
                    if (TotemMechanic.this.bulletSpin != 0.0f) {
                        float newSpin = this.bullet.getLocation().getYaw() + TotemMechanic.this.bulletSpin;
                        ol.setYaw(newSpin);
                    }
                    this.bullet.teleport(ol);
                } else {
                    this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.bullet.getLocation().clone().toVector()).multiply(1));
                    if (TotemMechanic.this.bulletSpin > 0.0f) {
                        float newSpin = this.bullet.getLocation().getYaw() + TotemMechanic.this.bulletSpin;
                        AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setEntityRotation(this.bullet, newSpin, newSpin);
                    }
                }
            }
            if (this.inRange != null && this.inRange.size() > 0) {
                ProjectileHitBox hitBox = new ProjectileHitBox(this.currentLocation, TotemMechanic.this.hitRadius, TotemMechanic.this.verticalHitRadius);
                for (AbstractEntity e : this.inRange) {
                    if (e.isDead() || !hitBox.contains(e.getLocation().add(0.0, 0.6, 0.0))) continue;
                    this.targets.add(e);
                    this.immune.put(e, System.currentTimeMillis());
                    break;
                }
                this.immune.entrySet().removeIf(entry -> (Long)entry.getValue() < System.currentTimeMillis() - 2000L);
            }
            if (TotemMechanic.this.onTickSkill.isPresent() && ((Skill)TotemMechanic.this.onTickSkill.get()).isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                AbstractLocation location = TotemMechanic.this.bulletType == Projectile.BulletType.ARROW ? this.previousLocation.clone() : this.currentLocation.clone();
                HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
                targets.add(location);
                sData.setLocationTargets(targets);
                sData.setOrigin(location);
                ((Skill)TotemMechanic.this.onTickSkill.get()).execute(sData);
            }
            if (this.targets.size() > 0) {
                this.doHit((HashSet)this.targets.clone());
                if (TotemMechanic.this.stopOnHitEntity) {
                    this.terminate();
                }
                --this.charges;
                if (TotemMechanic.this.maxCharges > 0 && this.charges <= 0) {
                    this.terminate();
                }
            }
            this.targets.clear();
        }

        public void doHit(HashSet<AbstractEntity> targets) {
            if (TotemMechanic.this.onHitSkill.isPresent() && ((Skill)TotemMechanic.this.onHitSkill.get()).isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                sData.setEntityTargets(targets);
                sData.setOrigin(this.currentLocation.clone());
                ((Skill)TotemMechanic.this.onHitSkill.get()).execute(sData);
            }
        }

        @Override
        public void setCancelled() {
            this.terminate();
        }

        @Override
        public boolean getCancelled() {
            return this.components.hasTerminated();
        }
    }
}

