/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.skills.variables.Variable;
import io.lumine.xikage.mythicmobs.skills.variables.VariableMechanic;
import io.lumine.xikage.mythicmobs.skills.variables.VariableRegistry;
import io.lumine.xikage.mythicmobs.skills.variables.types.FloatVariable;
import io.lumine.xikage.mythicmobs.skills.variables.types.IntegerVariable;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import net.objecthunter.exp4j.ExpressionBuilder;

@MythicMechanic(author="Ashijin", name="variableMath", aliases={"varMath", "mathVariable", "mathVar"}, description="Sets a variable to the result of a math equation, where 'x' is the variable's current value")
public class VariableMathMechanic
extends VariableMechanic
implements ITargetedEntitySkill {
    protected PlaceholderString equation;

    public VariableMathMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.equation = mlc.getPlaceholderString(new String[]{"equation", "eq", "e"}, "x", new String[0]);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        VariableRegistry variables = VariableMathMechanic.getVariableManager().getRegistry(this.scope, data, target);
        Variable var = variables.get(this.key);
        if (var == null) {
            return false;
        }
        String eq = this.equation.get(data, target);
        if (var instanceof IntegerVariable) {
            int val = ((IntegerVariable)var).getValue();
            double amount = new ExpressionBuilder(eq).variable("x").build().setVariable("x", val).evaluate();
            ((IntegerVariable)var).setValue((int)amount);
        } else if (var instanceof FloatVariable) {
            float val = ((FloatVariable)var).getValue();
            double amount = new ExpressionBuilder(eq).variable("x").build().setVariable("x", val).evaluate();
            ((FloatVariable)var).setValue((float)amount);
        } else {
            MythicLogger.errorMechanicConfig(this, this.config, "Could not perform math operation on non-numeric variable type");
            return false;
        }
        this.handleDuration(var);
        return true;
    }
}

