/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.skills.variables.Variable;
import io.lumine.xikage.mythicmobs.skills.variables.VariableMechanic;
import io.lumine.xikage.mythicmobs.skills.variables.VariableRegistry;
import io.lumine.xikage.mythicmobs.skills.variables.VariableType;
import net.objecthunter.exp4j.ExpressionBuilder;

public class VariableSetMechanic
extends VariableMechanic
implements ITargetedEntitySkill {
    protected PlaceholderString value;
    protected VariableType type;

    public VariableSetMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        try {
            this.value = PlaceholderString.of(mlc.getString(new String[]{"value", "val", "v"}, null, new String[0]));
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Variable value must be set.");
            return;
        }
        String strType = mlc.getString(new String[]{"type", "t"}, VariableType.INTEGER.toString(), new String[0]);
        try {
            this.type = VariableType.valueOf(strType.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "'" + strType + "' is not a valid variable type.");
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        Variable var;
        VariableRegistry variables = VariableSetMechanic.getVariableManager().getRegistry(this.scope, data, target);
        if (variables == null) {
            MythicLogger.errorMechanicConfig(this, this.config, "Failed to get variable registry");
            return false;
        }
        if (this.type == VariableType.INTEGER || this.type == VariableType.FLOAT) {
            String eq = this.value.get(data, target);
            double amount = new ExpressionBuilder(eq).build().evaluate();
            var = Variable.ofType(this.type, (Object)amount, this.duration);
        } else {
            var = Variable.ofType(this.type, (Object)this.value.get(data, target), this.duration);
        }
        variables.put(this.key, var);
        return true;
    }
}

