/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

@MythicMechanic(author="Ashijin", name="velocity", description="Sets the velocity on the target entity")
public class VelocityMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected float velocityX;
    protected float velocityY;
    protected float velocityZ;
    protected VelocityMode mode;

    public VelocityMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.velocityX = mlc.getFloat(new String[]{"velocityx", "vx", "x"}, 1.0f);
        this.velocityY = mlc.getFloat(new String[]{"velocityy", "vy", "y"}, 1.0f);
        this.velocityZ = mlc.getFloat(new String[]{"velocityz", "vz", "z"}, 1.0f);
        String strMode = mlc.getString(new String[]{"mode", "m"}, "SET", new String[0]);
        switch (strMode.toUpperCase()) {
            case "ADD": {
                this.mode = VelocityMode.ADD;
                break;
            }
            case "REMOVE": {
                this.mode = VelocityMode.REMOVE;
                break;
            }
            case "MULTIPLY": {
                this.mode = VelocityMode.MULTIPLY;
                break;
            }
            case "DIVIDE": {
                this.mode = VelocityMode.DIVIDE;
                break;
            }
            default: {
                this.mode = VelocityMode.SET;
            }
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity e = target.getBukkitEntity();
        Vector v = e.getVelocity();
        if (this.mode.equals((Object)VelocityMode.SET)) {
            v = new Vector(this.velocityX, this.velocityY, this.velocityZ);
        } else if (this.mode.equals((Object)VelocityMode.ADD)) {
            v.setX(v.getX() + (double)this.velocityX);
            v.setY(v.getY() + (double)this.velocityY);
            v.setZ(v.getZ() + (double)this.velocityZ);
        } else if (this.mode.equals((Object)VelocityMode.MULTIPLY)) {
            v.setX(v.getX() * (double)this.velocityX);
            v.setY(v.getY() * (double)this.velocityY);
            v.setZ(v.getZ() * (double)this.velocityZ);
        } else if (this.mode.equals((Object)VelocityMode.REMOVE)) {
            v.setX(v.getX() - (double)this.velocityX);
            v.setY(v.getY() - (double)this.velocityY);
            v.setZ(v.getZ() - (double)this.velocityZ);
        } else if (this.mode.equals((Object)VelocityMode.DIVIDE)) {
            v.setX(v.getX() / (double)this.velocityX);
            v.setY(v.getY() / (double)this.velocityY);
            v.setZ(v.getZ() / (double)this.velocityZ);
        }
        if (v.length() > 4.0) {
            v = v.normalize().multiply(4);
        }
        if (Double.isNaN(v.getX())) {
            v.setX(0);
        }
        if (Double.isNaN(v.getY())) {
            v.setY(0);
        }
        if (Double.isNaN(v.getZ())) {
            v.setZ(0);
        }
        e.setVelocity(v);
        return true;
    }

    static enum VelocityMode {
        SET,
        ADD,
        MULTIPLY,
        REMOVE,
        DIVIDE;

    }
}

