/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.placeholders.parsers;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.placeholders.GenericPlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderParser;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.RandomInt;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.StaticInt;
import io.lumine.xikage.mythicmobs.spawning.spawners.MythicSpawner;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import net.objecthunter.exp4j.ExpressionBuilder;

public class PlaceholderInt
extends PlaceholderParser {
    public PlaceholderInt(String string) {
        super(string);
        if (string != null && string.startsWith("=")) {
            this.doMath = true;
        }
    }

    public int get() {
        String string = this.strValue;
        if (this.papi) {
            string = MythicMobs.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        if (this.doMath) {
            try {
                return (int)new ExpressionBuilder(string).build().evaluate();
            }
            catch (Exception ex) {
                MythicLogger.error("Invalid math operation on PlaceholderString: " + this.strValue);
                ex.printStackTrace();
            }
        }
        return Integer.valueOf(string);
    }

    public int get(PlaceholderMeta meta) {
        return this.get(meta, meta.getTrigger());
    }

    public int get(AbstractEntity entity) {
        return this.get(null, entity);
    }

    public int get(PlaceholderMeta meta, AbstractEntity entity) {
        String string = this.parse(meta, entity);
        if (this.papi) {
            string = entity != null && entity.isPlayer() ? MythicMobs.inst().getCompatibility().getPlaceholderAPI().get().parse(string, entity.asPlayer()) : MythicMobs.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        if (this.doMath) {
            try {
                return (int)new ExpressionBuilder(string).build().evaluate();
            }
            catch (Exception ex) {
                MythicLogger.error("Invalid math operation on PlaceholderInt: " + this.strValue);
                ex.printStackTrace();
            }
        }
        if (string.contains(".")) {
            return Numbers.floor(Double.valueOf(string));
        }
        return Integer.valueOf(string);
    }

    public int get(SkillCaster caster) {
        return this.get(new GenericPlaceholderMeta(caster, caster.getEntity()));
    }

    public int get(MythicSpawner spawner) {
        String string = this.parse(spawner);
        if (this.papi) {
            string = MythicMobs.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        if (this.doMath) {
            try {
                return (int)new ExpressionBuilder(string).build().evaluate();
            }
            catch (Exception ex) {
                MythicLogger.error("Invalid math operation on PlaceholderInt: " + this.strValue);
                ex.printStackTrace();
            }
        }
        return Integer.valueOf(string);
    }

    public String toString() {
        return this.strValue;
    }

    public static PlaceholderInt of(String string) {
        try {
            if (io.lumine.xikage.mythicmobs.utils.numbers.RandomInt.matches(string)) {
                return new RandomInt(string);
            }
            if (string.matches("-?\\d+")) {
                return new StaticInt(string);
            }
            if (!MythicMobs.isVolatile()) {
                MythicLogger.error("Failed to parse Placeholder '" + string + "': Math and variables in numeric values require premium! Consider getting MythicMobs Premium at www.mythicmobs.net.");
                return new StaticInt("1");
            }
            return new PlaceholderInt(string);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MythicLogger.error("Failed to parse Placeholder '" + string + "': invalid syntax.");
            return new StaticInt("1");
        }
    }
}

