/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import io.lumine.xikage.mythicmobs.util.annotations.MythicTargeter;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@MythicTargeter(author="Ashijin", name="blocksinradius", aliases={}, description="Targets all blocks in the radius of the inherited target")
public class BlocksInRadiusTargeter
extends ILocationSelector {
    protected PlaceholderInt radius;
    protected float noise;
    protected double randomness;
    protected boolean sphere = false;
    private MaskType maskType;

    public BlocksInRadiusTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.radius = mlc.getPlaceholderInteger(new String[]{"radius", "r"}, 2, new String[0]);
        this.randomness = mlc.getDouble(new String[]{"noise", "n"}, 0.0);
        String shape = mlc.getString(new String[]{"shape", "s"}, "SPHERE", new String[0]).toUpperCase();
        this.sphere = shape.equals("SPHERE");
        boolean noAir = mlc.getBoolean(new String[]{"noair", "na"}, true);
        boolean onlyAir = mlc.getBoolean(new String[]{"onlyair", "oa"}, false);
        this.maskType = noAir && !onlyAir ? MaskType.IGNORE_AIR : (onlyAir ? MaskType.ONLY_AIR : MaskType.ALL);
    }

    @Override
    public HashSet<AbstractLocation> getLocations(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@BlocksInRadius targeter", new Object[0]);
        if (data.getEntityTargets() != null && !data.getEntityTargets().isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@BlocksInRadius targeter from Entities", new Object[0]);
            for (AbstractEntity e : data.getEntityTargets()) {
                AbstractLocation l = e.getLocation();
                for (AbstractLocation location : this.getBlocksInRadius(data, l)) {
                    targets.add(location);
                }
            }
        } else if (data.getLocationTargets() != null && !data.getLocationTargets().isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@BlocksInRadius targeter from Locations", new Object[0]);
            for (AbstractLocation l : data.getLocationTargets()) {
                for (AbstractLocation location : this.getBlocksInRadius(data, l)) {
                    targets.add(location);
                }
            }
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@BlocksInRadius has no inherited targets", new Object[0]);
        }
        return targets;
    }

    private List<AbstractLocation> getBlocksInRadius(SkillMetadata data, AbstractLocation origin) {
        ArrayList<AbstractLocation> blocks = new ArrayList<AbstractLocation>();
        int radius = this.radius.get(data);
        int radiusSq = (int)Math.pow(radius, 2.0);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    AbstractLocation newloc = new AbstractLocation(origin.getWorld(), origin.getX() + (double)x, origin.getY() + (double)y, origin.getZ() + (double)z);
                    if (this.sphere && origin.distanceSquared(newloc) > (double)radiusSq || this.randomness > 0.0 && this.randomness < Numbers.randomDouble()) continue;
                    if (this.maskType == MaskType.ALL) {
                        blocks.add(newloc);
                        continue;
                    }
                    if (this.maskType == MaskType.IGNORE_AIR && BukkitAdapter.adapt(newloc).getBlock().getType().isOccluding()) {
                        blocks.add(newloc);
                        continue;
                    }
                    if (this.maskType != MaskType.ONLY_AIR || BukkitAdapter.adapt(newloc).getBlock().getType().isOccluding()) continue;
                    blocks.add(newloc);
                }
            }
        }
        return blocks;
    }

    private static enum MaskType {
        ALL,
        IGNORE_AIR,
        ONLY_AIR;

    }
}

