/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import java.util.HashSet;

public class LocationTargeter
extends ILocationSelector {
    protected PlaceholderDouble x;
    protected PlaceholderDouble y;
    protected PlaceholderDouble z;
    protected PlaceholderDouble yaw;
    protected PlaceholderDouble pitch;

    public LocationTargeter(MythicLineConfig mlc) {
        super(mlc);
        String coords = mlc.getString(new String[]{"location", "loc", "l", "c"}, null, new String[0]);
        if (coords != null) {
            String[] split = coords.split(",");
            try {
                this.x = PlaceholderDouble.of(split[0]);
                this.y = PlaceholderDouble.of(split[1]);
                this.z = PlaceholderDouble.of(split[2]);
                this.yaw = split.length > 3 ? PlaceholderDouble.of(split[3]) : PlaceholderDouble.of("0");
                if (split.length > 4) {
                    this.pitch = PlaceholderDouble.of(split[4]);
                }
                this.pitch = PlaceholderDouble.of("0");
            }
            catch (Exception ex) {
                MythicLogger.errorTargeterConfig(this, mlc, "The 'location' attribute is required and must be in the format l=x,y,z.");
                return;
            }
        } else {
            this.x = mlc.getPlaceholderDouble("x", "0");
            this.y = mlc.getPlaceholderDouble("y", "0");
            this.z = mlc.getPlaceholderDouble("z", "0");
            this.yaw = mlc.getPlaceholderDouble("yaw", "0");
            this.pitch = mlc.getPlaceholderDouble("pitch", "0");
        }
    }

    @Override
    public HashSet<AbstractLocation> getLocations(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        double x = this.x.get(data);
        double y = this.y.get(data);
        double z = this.z.get(data);
        float yaw = (float)this.yaw.get(data);
        float pitch = (float)this.pitch.get(data);
        AbstractLocation l = MythicMobs.inst().server().newLocation(am.getEntity().getWorld(), x, y, z, yaw, pitch);
        targets.add(l);
        return targets;
    }
}

