/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import java.util.HashSet;

public class NearestPlayerTargeter
extends IEntitySelector {
    double radius;

    public NearestPlayerTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.radius = mlc.getDouble("radius", 5.0);
        this.radius = mlc.getDouble("r", this.radius);
    }

    @Override
    public HashSet<AbstractEntity> getEntities(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        AbstractPlayer nearest = null;
        for (AbstractPlayer p : MythicMobs.inst().getEntityManager().getPlayers(am.getEntity().getWorld())) {
            if (p.getUniqueId().equals(am.getEntity().getUniqueId()) || !p.getWorld().equals(am.getEntity().getWorld()) || !(am.getEntity().getLocation().distanceSquared(p.getLocation()) < Math.pow(this.radius, 2.0)) || nearest != null && !(am.getEntity().getLocation().distanceSquared(nearest.getLocation()) > am.getEntity().getLocation().distanceSquared(p.getLocation()))) continue;
            nearest = p;
        }
        if (nearest != null) {
            targets.add(nearest);
        }
        return targets;
    }
}

