/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import io.lumine.xikage.mythicmobs.util.annotations.MythicTargeter;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;

@MythicTargeter(author="Ashijin", name="obstructingBlock", aliases={}, description="Tries to target blocks in front of the caster that are obstructing it")
public class ObstructingBlockTargeter
extends ILocationSelector {
    public ObstructingBlockTargeter(MythicLineConfig mlc) {
        super(mlc);
    }

    @Override
    public HashSet<AbstractLocation> getLocations(SkillMetadata data) {
        Block frontBlock;
        SkillCaster am = data.getCaster();
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        Entity entity = BukkitAdapter.adapt(am.getEntity());
        Location location = entity.getLocation();
        float yaw = Math.round(entity.getLocation().getYaw() / 90.0f);
        BlockFace bf = null;
        if (yaw == -4.0f || yaw == 0.0f || yaw == 4.0f) {
            bf = BlockFace.SOUTH;
        } else if (yaw == -1.0f || yaw == 3.0f) {
            bf = BlockFace.EAST;
        } else if (yaw == -2.0f || yaw == 2.0f) {
            bf = BlockFace.NORTH;
        } else if (yaw == -3.0f || yaw == 1.0f) {
            bf = BlockFace.WEST;
        }
        Block targetBlock = frontBlock = entity.getLocation().getBlock().getRelative(bf, 1);
        int i = 0;
        while (targetBlock.isPassable()) {
            if (++i >= 10) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "-- No solid block found?", new Object[0]);
                return targets;
            }
            switch (i) {
                case 1: {
                    targetBlock = entity.getLocation().getBlock();
                    break;
                }
                case 2: {
                    targetBlock = frontBlock.getRelative(BlockFace.UP, 1);
                    break;
                }
                case 3: {
                    targetBlock = frontBlock.getRelative(BlockFace.UP, 2);
                    break;
                }
                case 4: {
                    targetBlock = frontBlock.getRelative(ObstructingBlockTargeter.getLeft(yaw), 1);
                    break;
                }
                case 5: {
                    targetBlock = frontBlock.getRelative(ObstructingBlockTargeter.getLeft(yaw), 1).getRelative(BlockFace.UP, 1);
                    break;
                }
                case 6: {
                    targetBlock = frontBlock.getRelative(ObstructingBlockTargeter.getLeft(yaw), 1).getRelative(BlockFace.UP, 2);
                    break;
                }
                case 7: {
                    targetBlock = frontBlock.getRelative(ObstructingBlockTargeter.getRight(yaw), 1);
                    break;
                }
                case 8: {
                    targetBlock = frontBlock.getRelative(ObstructingBlockTargeter.getRight(yaw), 1).getRelative(BlockFace.UP, 1);
                    break;
                }
                case 9: {
                    targetBlock = frontBlock.getRelative(ObstructingBlockTargeter.getRight(yaw), 1).getRelative(BlockFace.UP, 2);
                }
            }
        }
        targets.add(BukkitAdapter.adapt(targetBlock.getLocation()));
        return targets;
    }

    public static BlockFace getLeft(float yaw) {
        if (yaw == -4.0f || yaw == 0.0f || yaw == 4.0f) {
            return BlockFace.EAST;
        }
        if (yaw == -1.0f || yaw == 3.0f) {
            return BlockFace.NORTH;
        }
        if (yaw == -2.0f || yaw == 2.0f) {
            return BlockFace.WEST;
        }
        if (yaw == -3.0f || yaw == 1.0f) {
            return BlockFace.SOUTH;
        }
        return null;
    }

    public static BlockFace getRight(float yaw) {
        if (yaw == -4.0f || yaw == 0.0f || yaw == 4.0f) {
            return BlockFace.WEST;
        }
        if (yaw == -1.0f || yaw == 3.0f) {
            return BlockFace.SOUTH;
        }
        if (yaw == -2.0f || yaw == 2.0f) {
            return BlockFace.EAST;
        }
        if (yaw == -3.0f || yaw == 1.0f) {
            return BlockFace.NORTH;
        }
        return null;
    }
}

