/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import java.util.HashSet;

public class PlayerLocationsInRadiusTargeter
extends ILocationSelector {
    double radius;
    double yOffset;

    public PlayerLocationsInRadiusTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.radius = mlc.getDouble("radius", 5.0);
        this.radius = mlc.getDouble("r", this.radius);
        this.yOffset = mlc.getDouble("yoffset", 0.0);
        this.yOffset = mlc.getDouble("y", this.yOffset);
    }

    @Override
    public HashSet<AbstractLocation> getLocations(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        for (AbstractPlayer p : MythicMobs.inst().getEntityManager().getPlayers(am.getEntity().getWorld())) {
            if (!am.getLocation().getWorld().equals(p.getWorld()) || !(am.getEntity().getLocation().distanceSquared(p.getLocation()) < Math.pow(this.radius, 2.0))) continue;
            AbstractLocation l = p.getLocation();
            l.add(0.0, this.yOffset, 0.0);
            targets.add(l);
        }
        return targets;
    }
}

