/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import io.lumine.xikage.mythicmobs.util.annotations.MythicTargeter;
import java.util.HashSet;

@MythicTargeter(author="Ashijin", name="randomLocationsNearTargets", aliases={"randomLocationsNearTarget", "randomLocationsNearTargetEntities", "randomLocationsNearTargetLocations", "RLNT", "RLNTE", "RLNTL"}, description="Targets random locations near the inherited targets")
public class RandomLocationsNearTargetsTargeter
extends ILocationSelector {
    private PlaceholderInt amount;
    private int maxRadius;
    private int minRadius;
    private int minRadiusSq;
    private int spacing;
    private int spacingSq;

    public RandomLocationsNearTargetsTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 5, new String[0]);
        this.maxRadius = mlc.getInteger(new String[]{"radius", "r", "maxradius", "maxr"}, 5);
        this.minRadius = mlc.getInteger(new String[]{"minradius", "minr"}, 0);
        this.spacing = mlc.getInteger(new String[]{"spacing", "s"}, 0);
        this.minRadiusSq = this.minRadius * this.minRadius;
        this.spacingSq = this.spacing * this.spacing;
    }

    @Override
    public HashSet<AbstractLocation> getLocations(SkillMetadata data) {
        HashSet<AbstractLocation> targets;
        block9: {
            int amountSq;
            int amount;
            block8: {
                targets = new HashSet<AbstractLocation>();
                amount = this.amount.get(data);
                amountSq = amount * amount;
                if (data.getEntityTargets() == null) break block8;
                for (AbstractEntity e : data.getEntityTargets()) {
                    int i = 0;
                    int j = 0;
                    while (i < amount && j < amountSq) {
                        ++j;
                        MythicMobs.inst().getMobManager();
                        AbstractLocation l = MobManager.findSafeSpawnLocation(e.getLocation(), this.maxRadius, 1, 1, true, false);
                        if (this.minRadius > 0 && l.distanceSquared(e.getLocation()) < (double)this.minRadiusSq) continue;
                        if (this.spacing > 0) {
                            boolean bad = false;
                            for (AbstractLocation l2 : targets) {
                                if (!(l.distanceSquared(l2) < (double)this.spacingSq)) continue;
                                bad = true;
                                break;
                            }
                            if (bad) continue;
                        }
                        targets.add(l);
                        ++i;
                    }
                }
                break block9;
            }
            if (data.getLocationTargets() == null) break block9;
            for (AbstractLocation e : data.getLocationTargets()) {
                int i = 0;
                int j = 0;
                while (i < amount && j < amountSq) {
                    ++j;
                    MythicMobs.inst().getMobManager();
                    AbstractLocation l = MobManager.findSafeSpawnLocation(e, this.maxRadius, 1, 1, true, false);
                    if (this.minRadius > 0 && l.distanceSquared(e) < (double)this.minRadiusSq) continue;
                    if (this.spacing > 0) {
                        boolean bad = false;
                        for (AbstractLocation l2 : targets) {
                            if (!(l.distanceSquared(l2) < (double)this.spacingSq)) continue;
                            bad = true;
                            break;
                        }
                        if (bad) continue;
                    }
                    targets.add(l);
                    ++i;
                }
            }
        }
        return targets;
    }
}

