/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import io.lumine.xikage.mythicmobs.util.annotations.MythicTargeter;
import java.util.HashSet;
import org.bukkit.entity.Player;

@MythicTargeter(author="Ashijin", name="targetLocation", aliases={"targetLoc", "TL"}, description="Targets the location the caster is targeting")
public class TargetLocationTargeter
extends ILocationSelector {
    double yOffset;

    public TargetLocationTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.yOffset = mlc.getDouble(new String[]{"yoffset", "y"}, 0.0);
    }

    @Override
    public HashSet<AbstractLocation> getLocations(SkillMetadata data) {
        SkillCaster caster = data.getCaster();
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        AbstractLocation l = null;
        if (caster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)caster;
            if (am.hasThreatTable()) {
                if (am.getThreatTable().getTopThreatHolder() != null) {
                    l = am.getThreatTable().getTopThreatHolder().getLocation();
                }
            } else if (am.getEntity().isCreature()) {
                if (am.getEntity().getTarget() != null) {
                    l = am.getEntity().getTarget().getLocation();
                }
            } else {
                l = am.getLastAggroCause().getLocation();
            }
        } else if (caster.getEntity().isPlayer()) {
            l = BukkitAdapter.adapt(((Player)BukkitAdapter.adapt(data.getCaster().getEntity())).getTargetBlock(MythicMobs.inst().getConfiguration().getTransparentBlocks(), 64).getLocation());
        }
        if (l != null) {
            l.add(0.0, this.yOffset, 0.0);
            targets.add(l);
        }
        return targets;
    }
}

