/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.variables;

import com.google.gson.GsonBuilder;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitWorld;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.variables.Variable;
import io.lumine.xikage.mythicmobs.skills.variables.VariableRegistry;
import io.lumine.xikage.mythicmobs.skills.variables.VariableScope;
import io.lumine.xikage.mythicmobs.skills.variables.VariableSerializer;
import io.lumine.xikage.mythicmobs.utils.serialization.SerializingModule;
import io.lumine.xikage.mythicmobs.utils.serialization.WrappedJsonFile;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import java.lang.reflect.Type;

public class VariableManager
extends SerializingModule<MythicMobs>
implements Terminable {
    protected final MythicMobs core;
    private final WrappedJsonFile<VariableRegistry> globalRegistry;

    public VariableManager(MythicMobs core) {
        super(core, "SavedData");
        this.core = core;
        this.GSON = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter((Type)((Object)AbstractWorld.class), this.GSON.getAdapter(BukkitWorld.class)).registerTypeAdapter((Type)((Object)Variable.class), new VariableSerializer()).create();
        this.globalRegistry = this.loadFile(this.getModuleFile("global-data.json"), VariableRegistry.class);
    }

    @Override
    public void load(MythicMobs plugin) {
    }

    @Override
    public void unload() {
        this.globalRegistry.get().unload();
        this.globalRegistry.save();
    }

    public void save() {
        this.globalRegistry.get().clean();
        this.globalRegistry.save();
    }

    public VariableRegistry getRegistry(VariableScope scope, SkillMetadata meta, AbstractEntity entity) {
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Getting VariableRegistry in scope {0}", new Object[]{scope});
        switch (scope) {
            case CASTER: {
                SkillCaster caster = meta.getCaster();
                if (caster == null) {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "! Can't get registry for null caster", new Object[0]);
                    return null;
                }
                if (caster instanceof ActiveMob) {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting caster mob registry...", new Object[0]);
                    return ((ActiveMob)caster).getVariables();
                }
                if (caster.getEntity().isPlayer()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting caster player registry...", new Object[0]);
                    return this.core.getPlayerManager().getPlayerData(caster.getEntity().asPlayer()).getVariables();
                }
                return null;
            }
            case SKILL: {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting skill registry...", new Object[0]);
                return meta.getVariables();
            }
            case TARGET: {
                if (this.core.getMobManager().isActiveMob(entity)) {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting target mob registry...", new Object[0]);
                    return this.core.getMobManager().getMythicMobInstance(entity).getVariables();
                }
                if (!entity.isPlayer()) break;
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting target player registry...", new Object[0]);
                return this.core.getPlayerManager().getPlayerData(entity.asPlayer()).getVariables();
            }
            case WORLD: {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting world registry...", new Object[0]);
                SkillCaster caster = meta.getCaster();
                if (caster != null) {
                    return this.core.getWorldManager().getWorldData(caster.getEntity().getWorld()).getVariables();
                }
                if (entity != null) {
                    return this.core.getWorldManager().getWorldData(entity.getWorld()).getVariables();
                }
                return null;
            }
            case GLOBAL: {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting global registry...", new Object[0]);
                return this.globalRegistry.get();
            }
        }
        return null;
    }

    public VariableRegistry getRegistry(VariableScope scope, AbstractEntity entity) {
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Getting VariableRegistry for entity {} in scope {}", new Object[]{entity.getName(), scope});
        switch (scope) {
            case CASTER: {
                break;
            }
            case SKILL: {
                break;
            }
            case TARGET: {
                if (this.core.getMobManager().isActiveMob(entity)) {
                    return this.core.getMobManager().getMythicMobInstance(entity).getVariables();
                }
                if (!entity.isPlayer()) break;
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting target player registry...", new Object[0]);
                return this.core.getPlayerManager().getPlayerData(entity.asPlayer()).getVariables();
            }
            case WORLD: {
                return this.core.getWorldManager().getWorldData(entity.getWorld()).getVariables();
            }
            case GLOBAL: {
                return this.globalRegistry.get();
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "! Can't get caster registry in this context", new Object[0]);
        return null;
    }

    public VariableRegistry getRegistry(ActiveMob am) {
        return am.getVariables();
    }

    public VariableRegistry getRegistry(VariableScope scope, AbstractLocation target) {
        switch (scope) {
            case CASTER: {
                return null;
            }
            case SKILL: {
                break;
            }
            case TARGET: {
                break;
            }
            case WORLD: {
                return this.core.getWorldManager().getWorldData(target.getWorld()).getVariables();
            }
            case GLOBAL: {
                return this.globalRegistry.get();
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "! Can't get caster registry in this context", new Object[0]);
        return null;
    }

    public WrappedJsonFile<VariableRegistry> getGlobalRegistry() {
        return this.globalRegistry;
    }
}

